/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.dom.MediaListImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleImpl
extends AbstractCSSRuleImpl
implements CSSImportRule {
    private static final long serialVersionUID = 7807829682009179339L;
    private String href_;
    private MediaList media_;

    public void setHref(String string) {
        this.href_ = string;
    }

    public void setMedia(MediaList mediaList) {
        this.media_ = mediaList;
    }

    public CSSImportRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string, MediaList mediaList) {
        super(cSSStyleSheetImpl, cSSRule);
        this.href_ = string;
        this.media_ = mediaList;
    }

    public CSSImportRuleImpl() {
    }

    public short getType() {
        return 3;
    }

    public String getCssText(CSSFormat cSSFormat) {
        MediaList mediaList;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@import");
        String string = this.getHref();
        if (null != string) {
            stringBuilder.append(" url(").append(string).append(")");
        }
        if (null != (mediaList = this.getMedia()) && mediaList.getLength() > 0) {
            stringBuilder.append(" ").append(((MediaListImpl)this.getMedia()).getMediaText(cSSFormat));
        }
        stringBuilder.append(";");
        return stringBuilder.toString();
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 3) {
                throw new DOMExceptionImpl(13, 6);
            }
            this.href_ = ((CSSImportRuleImpl)cSSRule).href_;
            this.media_ = ((CSSImportRuleImpl)cSSRule).media_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public String getHref() {
        return this.href_;
    }

    public MediaList getMedia() {
        return this.media_;
    }

    public CSSStyleSheet getStyleSheet() {
        return null;
    }

    public String toString() {
        return this.getCssText(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSImportRule)) {
            return false;
        }
        CSSImportRule cSSImportRule = (CSSImportRule)object;
        return super.equals(object) && LangUtils.equals(this.getHref(), cSSImportRule.getHref()) && LangUtils.equals(this.getMedia(), cSSImportRule.getMedia());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.href_);
        n = LangUtils.hashCode(n, this.media_);
        return n;
    }
}

