/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleDeclarationImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSFontFaceRuleImpl
extends AbstractCSSRuleImpl
implements CSSFontFaceRule {
    private static final long serialVersionUID = -3604191834588759088L;
    private CSSStyleDeclarationImpl style_;

    public CSSFontFaceRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule) {
        super(cSSStyleSheetImpl, cSSRule);
    }

    public CSSFontFaceRuleImpl() {
    }

    public short getType() {
        return 5;
    }

    public String getCssText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@font-face {");
        CSSStyleDeclaration cSSStyleDeclaration = this.getStyle();
        if (null != cSSStyleDeclaration) {
            stringBuilder.append(cSSStyleDeclaration.getCssText());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 5) {
                throw new DOMExceptionImpl(13, 8);
            }
            this.style_ = ((CSSFontFaceRuleImpl)cSSRule).style_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl cSSStyleDeclarationImpl) {
        this.style_ = cSSStyleDeclarationImpl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSFontFaceRule)) {
            return false;
        }
        CSSFontFaceRule cSSFontFaceRule = (CSSFontFaceRule)object;
        return super.equals(object) && LangUtils.equals(this.getStyle(), cSSFontFaceRule.getStyle());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.style_);
        return n;
    }

    public String toString() {
        return this.getCssText(null);
    }
}

