/*
 * Decompiled with CFR 0.152.
 */
package ai.com.lowagie.text.pdf.hyphenation;

import ai.com.lowagie.text.pdf.hyphenation.ByteVector;
import ai.com.lowagie.text.pdf.hyphenation.Hyphenation;
import ai.com.lowagie.text.pdf.hyphenation.PatternConsumer;
import ai.com.lowagie.text.pdf.hyphenation.SimplePatternParser;
import ai.com.lowagie.text.pdf.hyphenation.TernaryTree;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer {
    private static final long serialVersionUID = -7763254239309429432L;
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String string) {
        int n = string.length();
        int n2 = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int n3 = this.vspace.alloc(n2);
        byte[] byArray = this.vspace.getArray();
        for (int i = 0; i < n; ++i) {
            int n4 = i >> 1;
            byte by = (byte)(string.charAt(i) - 48 + 1 & 0xF);
            byArray[n4 + n3] = (i & 1) == 1 ? (byte)(byArray[n4 + n3] | by) : (byte)(by << 4);
        }
        byArray[n2 - 1 + n3] = 0;
        return n3;
    }

    protected String unpackValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1 + 48);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        return stringBuffer.toString();
    }

    public void loadSimplePatterns(InputStream inputStream) {
        SimplePatternParser simplePatternParser = new SimplePatternParser();
        this.ivalues = new TernaryTree();
        simplePatternParser.parse(inputStream, this);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String string) {
        int n = super.find(string);
        if (n >= 0) {
            return this.unpackValues(n);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n, char[] cArray2, int n2) {
        while (cArray[n] == cArray2[n2]) {
            if (cArray[n] == '\u0000') {
                return 0;
            }
            ++n;
            ++n2;
        }
        if (cArray2[n2] == '\u0000') {
            return 0;
        }
        return cArray[n] - cArray2[n2];
    }

    protected byte[] getValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        byte[] byArray = new byte[stringBuffer.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)stringBuffer.charAt(i);
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n, byte[] byArray) {
        int n2 = n;
        char c = cArray[n2];
        char c2 = this.root;
        block0: while (c2 > '\u0000' && c2 < this.sc.length) {
            int n3;
            int n4;
            byte[] byArray2;
            if (this.sc[c2] == '\uffff') {
                if (this.hstrcmp(cArray, n2, this.kv.getArray(), this.lo[c2]) == 0) {
                    byArray2 = this.getValues(this.eq[c2]);
                    n4 = n;
                    for (n3 = 0; n3 < byArray2.length; ++n3) {
                        if (n4 < byArray.length && byArray2[n3] > byArray[n4]) {
                            byArray[n4] = byArray2[n3];
                        }
                        ++n4;
                    }
                }
                return;
            }
            n4 = c - this.sc[c2];
            if (n4 == 0) {
                if (c == '\u0000') break;
                c = cArray[++n2];
                char c3 = c2 = this.eq[c2];
                while (c3 > '\u0000' && c3 < this.sc.length && this.sc[c3] != '\uffff') {
                    if (this.sc[c3] == '\u0000') {
                        byArray2 = this.getValues(this.eq[c3]);
                        n3 = n;
                        for (int i = 0; i < byArray2.length; ++i) {
                            if (n3 < byArray.length && byArray2[i] > byArray[n3]) {
                                byArray[n3] = byArray2[i];
                            }
                            ++n3;
                        }
                        continue block0;
                    }
                    c3 = this.lo[c3];
                }
                continue;
            }
            c2 = n4 < 0 ? this.lo[c2] : this.hi[c2];
        }
    }

    public Hyphenation hyphenate(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        return this.hyphenate(cArray, 0, cArray.length, n, n2);
    }

    public Hyphenation hyphenate(char[] cArray, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        char[] cArray2 = new char[n2 + 3];
        char[] cArray3 = new char[2];
        int n6 = 0;
        int n7 = n2;
        boolean bl = false;
        for (n5 = 1; n5 <= n2; ++n5) {
            cArray3[0] = cArray[n + n5 - 1];
            int n8 = this.classmap.find(cArray3, 0);
            if (n8 < 0) {
                if (n5 == 1 + n6) {
                    ++n6;
                } else {
                    bl = true;
                }
                --n7;
                continue;
            }
            if (!bl) {
                cArray2[n5 - n6] = (char)n8;
                continue;
            }
            return null;
        }
        n2 = n7;
        if (n2 < n3 + n4) {
            return null;
        }
        int[] nArray = new int[n2 + 1];
        int n9 = 0;
        String string = new String(cArray2, 1, n2);
        if (this.stoplist.containsKey(string)) {
            object = (ArrayList)this.stoplist.get(string);
            int n10 = 0;
            for (n5 = 0; n5 < ((ArrayList)object).size(); ++n5) {
                Object e = ((ArrayList)object).get(n5);
                if (!(e instanceof String) || (n10 += ((String)e).length()) < n3 || n10 >= n2 - n4) continue;
                nArray[n9++] = n10 + n6;
            }
        } else {
            cArray2[0] = 46;
            cArray2[n2 + 1] = 46;
            cArray2[n2 + 2] = '\u0000';
            object = new byte[n2 + 3];
            for (n5 = 0; n5 < n2 + 1; ++n5) {
                this.searchPatterns(cArray2, n5, (byte[])object);
            }
            for (n5 = 0; n5 < n2; ++n5) {
                if ((object[n5 + 1] & 1) != 1 || n5 < n3 || n5 > n2 - n4) continue;
                nArray[n9++] = n5 + n6;
            }
        }
        if (n9 > 0) {
            object = new int[n9];
            System.arraycopy(nArray, 0, object, 0, n9);
            return new Hyphenation(new String(cArray, n, n2), (int[])object);
        }
        return null;
    }

    public void addClass(String string) {
        if (string.length() > 0) {
            char c = string.charAt(0);
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            for (int i = 0; i < string.length(); ++i) {
                cArray[0] = string.charAt(i);
                this.classmap.insert(cArray, 0, c);
            }
        }
    }

    public void addException(String string, ArrayList arrayList) {
        this.stoplist.put(string, arrayList);
    }

    public void addPattern(String string, String string2) {
        int n = this.ivalues.find(string2);
        if (n <= 0) {
            n = this.packValues(string2);
            this.ivalues.insert(string2, (char)n);
        }
        this.insert(string, (char)n);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }
}

