/*
 * Decompiled with CFR 0.152.
 */
package ai.com.lowagie.text.pdf;

import ai.com.lowagie.text.pdf.PdfArray;
import ai.com.lowagie.text.pdf.PdfLiteral;
import ai.com.lowagie.text.pdf.PdfName;
import ai.com.lowagie.text.pdf.PdfNumber;
import ai.com.lowagie.text.pdf.PdfRectangle;
import ai.com.lowagie.text.pdf.PdfStream;
import ai.com.lowagie.text.pdf.PdfTemplate;

public class PdfFormXObject
extends PdfStream {
    public static final PdfNumber ZERO = new PdfNumber(0);
    public static final PdfNumber ONE = new PdfNumber(1);
    public static final PdfLiteral MATRIX = new PdfLiteral("[1 0 0 1 0 0]");

    PdfFormXObject(PdfTemplate pdfTemplate, int n) {
        PdfArray pdfArray;
        this.put(PdfName.TYPE, PdfName.XOBJECT);
        this.put(PdfName.SUBTYPE, PdfName.FORM);
        this.put(PdfName.RESOURCES, pdfTemplate.getResources());
        this.put(PdfName.BBOX, new PdfRectangle(pdfTemplate.getBoundingBox()));
        this.put(PdfName.FORMTYPE, ONE);
        if (pdfTemplate.getLayer() != null) {
            this.put(PdfName.OC, pdfTemplate.getLayer().getRef());
        }
        if (pdfTemplate.getGroup() != null) {
            this.put(PdfName.GROUP, pdfTemplate.getGroup());
        }
        if ((pdfArray = pdfTemplate.getMatrix()) == null) {
            this.put(PdfName.MATRIX, MATRIX);
        } else {
            this.put(PdfName.MATRIX, pdfArray);
        }
        this.bytes = pdfTemplate.toPdf(null);
        this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
        this.flateCompress(n);
    }
}

