/*
 * Decompiled with CFR 0.152.
 */
package ai.com.lowagie.text.pdf;

import ai.com.lowagie.text.pdf.BaseFont;
import ai.com.lowagie.text.pdf.PdfEncodings;
import ai.com.lowagie.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.StringTokenizer;

public class GlyphList {
    private static HashMap unicode2names = new HashMap();
    private static HashMap names2unicode = new HashMap();

    public static int[] nameToUnicode(String string) {
        return (int[])names2unicode.get(string);
    }

    public static String unicodeToName(int n) {
        return (String)unicode2names.get(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = BaseFont.getResourceStream("ai/com/lowagie/text/pdf/fonts/glyphlist.txt", new FontsResourceAnchor().getClass().getClassLoader());
            if (inputStream == null) {
                String string = "glyphlist.txt not found as resource. (It must exist as resource in the package ai.com.lowagie.text.pdf.fonts)";
                throw new Exception(string);
            }
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            inputStream = null;
            String string = PdfEncodings.convertToString(byteArrayOutputStream.toByteArray(), null);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("#")) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ;\r\n\t\f");
                String string3 = null;
                String string4 = null;
                if (!stringTokenizer2.hasMoreTokens()) continue;
                string3 = stringTokenizer2.nextToken();
                if (!stringTokenizer2.hasMoreTokens()) continue;
                string4 = stringTokenizer2.nextToken();
                Integer n2 = Integer.valueOf(string4, 16);
                unicode2names.put(n2, string3);
                names2unicode.put(string3, new int[]{n2});
            }
        }
        catch (Exception exception) {
            System.err.println("glyphlist.txt loading error: " + exception.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

