/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.qrcode.decoder;

import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.common.BitSource;
import ai.com.google.zxing.common.CharacterSetECI;
import ai.com.google.zxing.common.DecoderResult;
import ai.com.google.zxing.common.StringUtils;
import ai.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import ai.com.google.zxing.qrcode.decoder.Mode;
import ai.com.google.zxing.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel, Hashtable hashtable) throws FormatException {
        Mode mode;
        BitSource bitSource = new BitSource(byArray);
        StringBuffer stringBuffer = new StringBuffer(50);
        CharacterSetECI characterSetECI = null;
        boolean bl = false;
        Vector vector = new Vector(1);
        do {
            int n;
            if (bitSource.available() < 4) {
                mode = Mode.TERMINATOR;
            } else {
                try {
                    mode = Mode.forBits(bitSource.readBits(4));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FormatException.getFormatInstance();
                }
            }
            if (mode.equals(Mode.TERMINATOR)) continue;
            if (mode.equals(Mode.FNC1_FIRST_POSITION) || mode.equals(Mode.FNC1_SECOND_POSITION)) {
                bl = true;
                continue;
            }
            if (mode.equals(Mode.STRUCTURED_APPEND)) {
                bitSource.readBits(16);
                continue;
            }
            if (mode.equals(Mode.ECI)) {
                n = DecodedBitStreamParser.parseECIValue(bitSource);
                characterSetECI = CharacterSetECI.getCharacterSetECIByValue(n);
                if (characterSetECI != null) continue;
                throw FormatException.getFormatInstance();
            }
            if (mode.equals(Mode.HANZI)) {
                n = bitSource.readBits(4);
                int n2 = bitSource.readBits(mode.getCharacterCountBits(version));
                if (n != 1) continue;
                DecodedBitStreamParser.decodeHanziSegment(bitSource, stringBuffer, n2);
                continue;
            }
            n = bitSource.readBits(mode.getCharacterCountBits(version));
            if (mode.equals(Mode.NUMERIC)) {
                DecodedBitStreamParser.decodeNumericSegment(bitSource, stringBuffer, n);
                continue;
            }
            if (mode.equals(Mode.ALPHANUMERIC)) {
                DecodedBitStreamParser.decodeAlphanumericSegment(bitSource, stringBuffer, n, bl);
                continue;
            }
            if (mode.equals(Mode.BYTE)) {
                DecodedBitStreamParser.decodeByteSegment(bitSource, stringBuffer, n, characterSetECI, vector, hashtable);
                continue;
            }
            if (mode.equals(Mode.KANJI)) {
                DecodedBitStreamParser.decodeKanjiSegment(bitSource, stringBuffer, n);
                continue;
            }
            throw FormatException.getFormatInstance();
        } while (!mode.equals(Mode.TERMINATOR));
        return new DecoderResult(byArray, stringBuffer.toString(), vector.isEmpty() ? null : vector, errorCorrectionLevel == null ? null : errorCorrectionLevel.toString());
    }

    private static void decodeHanziSegment(BitSource bitSource, StringBuffer stringBuffer, int n) throws FormatException {
        if (n * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        while (n > 0) {
            int n3 = bitSource.readBits(13);
            int n4 = n3 / 96 << 8 | n3 % 96;
            n4 = n4 < 959 ? (n4 += 41377) : (n4 += 42657);
            byArray[n2] = (byte)(n4 >> 8 & 0xFF);
            byArray[n2 + 1] = (byte)(n4 & 0xFF);
            n2 += 2;
            --n;
        }
        try {
            stringBuffer.append(new String(byArray, "GB2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeKanjiSegment(BitSource bitSource, StringBuffer stringBuffer, int n) throws FormatException {
        if (n * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n];
        int n2 = 0;
        while (n > 0) {
            int n3 = bitSource.readBits(13);
            int n4 = n3 / 192 << 8 | n3 % 192;
            n4 = n4 < 7936 ? (n4 += 33088) : (n4 += 49472);
            byArray[n2] = (byte)(n4 >> 8);
            byArray[n2 + 1] = (byte)n4;
            n2 += 2;
            --n;
        }
        try {
            stringBuffer.append(new String(byArray, "SJIS"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeByteSegment(BitSource bitSource, StringBuffer stringBuffer, int n, CharacterSetECI characterSetECI, Vector vector, Hashtable hashtable) throws FormatException {
        if (n << 3 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)bitSource.readBits(8);
        }
        String string = characterSetECI == null ? StringUtils.guessEncoding(byArray, hashtable) : characterSetECI.getEncodingName();
        try {
            stringBuffer.append(new String(byArray, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
        vector.addElement(byArray);
    }

    private static char toAlphaNumericChar(int n) throws FormatException {
        if (n >= ALPHANUMERIC_CHARS.length) {
            throw FormatException.getFormatInstance();
        }
        return ALPHANUMERIC_CHARS[n];
    }

    private static void decodeAlphanumericSegment(BitSource bitSource, StringBuffer stringBuffer, int n, boolean bl) throws FormatException {
        int n2;
        int n3 = stringBuffer.length();
        while (n > 1) {
            n2 = bitSource.readBits(11);
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 45));
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 45));
            n -= 2;
        }
        if (n == 1) {
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(bitSource.readBits(6)));
        }
        if (bl) {
            for (n2 = n3; n2 < stringBuffer.length(); ++n2) {
                if (stringBuffer.charAt(n2) != '%') continue;
                if (n2 < stringBuffer.length() - 1 && stringBuffer.charAt(n2 + 1) == '%') {
                    stringBuffer.deleteCharAt(n2 + 1);
                    continue;
                }
                stringBuffer.setCharAt(n2, '\u001d');
            }
        }
    }

    private static void decodeNumericSegment(BitSource bitSource, StringBuffer stringBuffer, int n) throws FormatException {
        int n2;
        while (n >= 3) {
            n2 = bitSource.readBits(10);
            if (n2 >= 1000) {
                throw FormatException.getFormatInstance();
            }
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 100));
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 10 % 10));
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 10));
            n -= 3;
        }
        if (n == 2) {
            n2 = bitSource.readBits(7);
            if (n2 >= 100) {
                throw FormatException.getFormatInstance();
            }
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 / 10));
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2 % 10));
        } else if (n == 1) {
            n2 = bitSource.readBits(4);
            if (n2 >= 10) {
                throw FormatException.getFormatInstance();
            }
            stringBuffer.append(DecodedBitStreamParser.toAlphaNumericChar(n2));
        }
    }

    private static int parseECIValue(BitSource bitSource) {
        int n = bitSource.readBits(8);
        if ((n & 0x80) == 0) {
            return n & 0x7F;
        }
        if ((n & 0xC0) == 128) {
            int n2 = bitSource.readBits(8);
            return (n & 0x3F) << 8 | n2;
        }
        if ((n & 0xE0) == 192) {
            int n3 = bitSource.readBits(16);
            return (n & 0x1F) << 16 | n3;
        }
        throw new IllegalArgumentException("Bad ECI bits starting with byte " + n);
    }
}

