/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.qrcode.decoder;

import ai.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import ai.com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int n, byte[] byArray) {
        this.numDataCodewords = n;
        this.codewords = byArray;
    }

    static DataBlock[] getDataBlocks(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (byArray.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel);
        int n7 = 0;
        Version.ECB[] eCBArray = eCBlocks.getECBlocks();
        for (int i = 0; i < eCBArray.length; ++i) {
            n7 += eCBArray[i].getCount();
        }
        DataBlock[] dataBlockArray = new DataBlock[n7];
        int n8 = 0;
        for (n6 = 0; n6 < eCBArray.length; ++n6) {
            Version.ECB eCB = eCBArray[n6];
            for (n5 = 0; n5 < eCB.getCount(); ++n5) {
                n4 = eCB.getDataCodewords();
                n3 = eCBlocks.getECCodewordsPerBlock() + n4;
                dataBlockArray[n8++] = new DataBlock(n4, new byte[n3]);
            }
        }
        n6 = dataBlockArray[0].codewords.length;
        for (n2 = dataBlockArray.length - 1; n2 >= 0 && (n5 = dataBlockArray[n2].codewords.length) != n6; --n2) {
        }
        ++n2;
        n5 = n6 - eCBlocks.getECCodewordsPerBlock();
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n = 0; n < n8; ++n) {
                dataBlockArray[n].codewords[n3] = byArray[n4++];
            }
        }
        for (n3 = n2; n3 < n8; ++n3) {
            dataBlockArray[n3].codewords[n5] = byArray[n4++];
        }
        n3 = dataBlockArray[0].codewords.length;
        for (n = n5; n < n3; ++n) {
            for (int i = 0; i < n8; ++i) {
                int n9 = i < n2 ? n : n + 1;
                dataBlockArray[i].codewords[n9] = byArray[n4++];
            }
        }
        return dataBlockArray;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

