/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.qrcode;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.EncodeHintType;
import ai.com.google.zxing.Writer;
import ai.com.google.zxing.WriterException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import ai.com.google.zxing.qrcode.encoder.ByteMatrix;
import ai.com.google.zxing.qrcode.encoder.Encoder;
import ai.com.google.zxing.qrcode.encoder.QRCode;
import java.util.Hashtable;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 1;

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + barcodeFormat);
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n + 'x' + n2);
        }
        Object object2 = ErrorCorrectionLevel.L;
        if (hashtable != null && (object = (ErrorCorrectionLevel)hashtable.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            object2 = object;
        }
        object = new QRCode();
        Encoder.encode(string, (ErrorCorrectionLevel)object2, hashtable, (QRCode)object);
        return QRCodeWriter.renderResult((QRCode)object, n, n2);
    }

    private static BitMatrix renderResult(QRCode qRCode, int n, int n2) {
        ByteMatrix byteMatrix = qRCode.getMatrix();
        int n3 = byteMatrix.getWidth();
        int n4 = byteMatrix.getHeight();
        int n5 = n3 + 2;
        int n6 = n4 + 2;
        int n7 = Math.max(n, n5);
        int n8 = Math.max(n2, n6);
        int n9 = Math.min(n7 / n5, n8 / n6);
        int n10 = (n7 - n3 * n9) / 2;
        int n11 = (n8 - n4 * n9) / 2;
        BitMatrix bitMatrix = new BitMatrix(n7, n8);
        int n12 = 0;
        int n13 = n11;
        while (n12 < n4) {
            int n14 = 0;
            int n15 = n10;
            while (n14 < n3) {
                if (byteMatrix.get(n14, n12) == 1) {
                    bitMatrix.setRegion(n15, n13, n9, n9);
                }
                ++n14;
                n15 += n9;
            }
            ++n12;
            n13 += n9;
        }
        return bitMatrix;
    }
}

