/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.qrcode;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Reader;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultMetadataType;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DecoderResult;
import ai.com.google.zxing.common.DetectorResult;
import ai.com.google.zxing.qrcode.decoder.Decoder;
import ai.com.google.zxing.qrcode.detector.Detector;
import java.util.Hashtable;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    protected Decoder getDecoder() {
        return this.decoder;
    }

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (hashtable != null && hashtable.containsKey(DecodeHintType.PURE_BARCODE)) {
            object = QRCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object, hashtable);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect(hashtable);
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits(), hashtable);
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
        if (decoderResult.getByteSegments() != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
        }
        if (decoderResult.getECLevel() != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel().toString());
        }
        return object;
    }

    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = QRCodeReader.moduleSize(nArray, bitMatrix);
        int n2 = nArray[1];
        int n3 = nArray2[1];
        int n4 = nArray[0];
        int n5 = nArray2[0];
        int n6 = (n5 - n4 + 1) / n;
        int n7 = (n3 - n2 + 1) / n;
        if (n6 == 0 || n7 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n7 != n6) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = n >> 1;
        n2 += n8;
        n4 += n8;
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        for (int i = 0; i < n7; ++i) {
            int n9 = n2 + i * n;
            for (int j = 0; j < n6; ++j) {
                if (!bitMatrix.get(n4 + j * n, n9)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        int n4 = nArray[0];
        for (n = nArray[1]; n4 < n3 && n < n2 && bitMatrix.get(n4, n); ++n4, ++n) {
        }
        if (n4 == n3 || n == n2) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n5 = n4 - nArray[0];
        if (n5 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n5;
    }
}

