/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.pdf417.detector;

import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DetectorResult;
import ai.com.google.zxing.common.GridSampler;
import java.util.Hashtable;

public final class Detector {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 204;
    private static final int SKEW_THRESHOLD = 2;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] START_PATTERN_REVERSE = new int[]{3, 1, 1, 1, 1, 1, 1, 8};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int[] STOP_PATTERN_REVERSE = new int[]{1, 2, 1, 1, 1, 3, 1, 1, 7};
    private final BinaryBitmap image;

    public Detector(BinaryBitmap binaryBitmap) {
        this.image = binaryBitmap;
    }

    public DetectorResult detect() throws NotFoundException {
        return this.detect(null);
    }

    public DetectorResult detect(Hashtable hashtable) throws NotFoundException {
        BitMatrix bitMatrix = this.image.getBlackMatrix();
        ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix);
        if (resultPointArray == null) {
            resultPointArray = Detector.findVertices180(bitMatrix);
            if (resultPointArray != null) {
                Detector.correctCodeWordVertices(resultPointArray, true);
            }
        } else {
            Detector.correctCodeWordVertices(resultPointArray, false);
        }
        if (resultPointArray == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        float f = Detector.computeModuleWidth(resultPointArray);
        if (f < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = Detector.computeDimension(resultPointArray[4], resultPointArray[6], resultPointArray[5], resultPointArray[7], f);
        if (n < 1) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bitMatrix2 = Detector.sampleGrid(bitMatrix, resultPointArray[4], resultPointArray[5], resultPointArray[6], resultPointArray[7], n);
        return new DetectorResult(bitMatrix2, new ResultPoint[]{resultPointArray[4], resultPointArray[5], resultPointArray[6], resultPointArray[7]});
    }

    private static ResultPoint[] findVertices(BitMatrix bitMatrix) {
        int[] nArray;
        int n;
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            nArray = Detector.findGuardPattern(bitMatrix, 0, n, n3, false, START_PATTERN);
            if (nArray == null) continue;
            resultPointArray[0] = new ResultPoint(nArray[0], n);
            resultPointArray[4] = new ResultPoint(nArray[1], n);
            bl = true;
            break;
        }
        if (bl) {
            bl = false;
            for (n = n2 - 1; n > 0; --n) {
                nArray = Detector.findGuardPattern(bitMatrix, 0, n, n3, false, START_PATTERN);
                if (nArray == null) continue;
                resultPointArray[1] = new ResultPoint(nArray[0], n);
                resultPointArray[5] = new ResultPoint(nArray[1], n);
                bl = true;
                break;
            }
        }
        if (bl) {
            bl = false;
            for (n = 0; n < n2; ++n) {
                nArray = Detector.findGuardPattern(bitMatrix, 0, n, n3, false, STOP_PATTERN);
                if (nArray == null) continue;
                resultPointArray[2] = new ResultPoint(nArray[1], n);
                resultPointArray[6] = new ResultPoint(nArray[0], n);
                bl = true;
                break;
            }
        }
        if (bl) {
            bl = false;
            for (n = n2 - 1; n > 0; --n) {
                nArray = Detector.findGuardPattern(bitMatrix, 0, n, n3, false, STOP_PATTERN);
                if (nArray == null) continue;
                resultPointArray[3] = new ResultPoint(nArray[1], n);
                resultPointArray[7] = new ResultPoint(nArray[0], n);
                bl = true;
                break;
            }
        }
        return bl ? resultPointArray : null;
    }

    private static ResultPoint[] findVertices180(BitMatrix bitMatrix) {
        int[] nArray;
        int n;
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        int n4 = n3 >> 1;
        ResultPoint[] resultPointArray = new ResultPoint[8];
        boolean bl = false;
        for (n = n2 - 1; n > 0; --n) {
            nArray = Detector.findGuardPattern(bitMatrix, n4, n, n4, true, START_PATTERN_REVERSE);
            if (nArray == null) continue;
            resultPointArray[0] = new ResultPoint(nArray[1], n);
            resultPointArray[4] = new ResultPoint(nArray[0], n);
            bl = true;
            break;
        }
        if (bl) {
            bl = false;
            for (n = 0; n < n2; ++n) {
                nArray = Detector.findGuardPattern(bitMatrix, n4, n, n4, true, START_PATTERN_REVERSE);
                if (nArray == null) continue;
                resultPointArray[1] = new ResultPoint(nArray[1], n);
                resultPointArray[5] = new ResultPoint(nArray[0], n);
                bl = true;
                break;
            }
        }
        if (bl) {
            bl = false;
            for (n = n2 - 1; n > 0; --n) {
                nArray = Detector.findGuardPattern(bitMatrix, 0, n, n4, false, STOP_PATTERN_REVERSE);
                if (nArray == null) continue;
                resultPointArray[2] = new ResultPoint(nArray[0], n);
                resultPointArray[6] = new ResultPoint(nArray[1], n);
                bl = true;
                break;
            }
        }
        if (bl) {
            bl = false;
            for (n = 0; n < n2; ++n) {
                nArray = Detector.findGuardPattern(bitMatrix, 0, n, n4, false, STOP_PATTERN_REVERSE);
                if (nArray == null) continue;
                resultPointArray[3] = new ResultPoint(nArray[0], n);
                resultPointArray[7] = new ResultPoint(nArray[1], n);
                bl = true;
                break;
            }
        }
        return bl ? resultPointArray : null;
    }

    private static void correctCodeWordVertices(ResultPoint[] resultPointArray, boolean bl) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = resultPointArray[4].getY() - resultPointArray[6].getY();
        if (bl) {
            f5 = -f5;
        }
        if (f5 > 2.0f) {
            f4 = resultPointArray[4].getX() - resultPointArray[0].getX();
            f3 = resultPointArray[6].getX() - resultPointArray[0].getX();
            f2 = resultPointArray[6].getY() - resultPointArray[0].getY();
            f = f4 * f2 / f3;
            resultPointArray[4] = new ResultPoint(resultPointArray[4].getX(), resultPointArray[4].getY() + f);
        } else if (-f5 > 2.0f) {
            f4 = resultPointArray[2].getX() - resultPointArray[6].getX();
            f3 = resultPointArray[2].getX() - resultPointArray[4].getX();
            f2 = resultPointArray[2].getY() - resultPointArray[4].getY();
            f = f4 * f2 / f3;
            resultPointArray[6] = new ResultPoint(resultPointArray[6].getX(), resultPointArray[6].getY() - f);
        }
        f5 = resultPointArray[7].getY() - resultPointArray[5].getY();
        if (bl) {
            f5 = -f5;
        }
        if (f5 > 2.0f) {
            f4 = resultPointArray[5].getX() - resultPointArray[1].getX();
            f3 = resultPointArray[7].getX() - resultPointArray[1].getX();
            f2 = resultPointArray[7].getY() - resultPointArray[1].getY();
            f = f4 * f2 / f3;
            resultPointArray[5] = new ResultPoint(resultPointArray[5].getX(), resultPointArray[5].getY() + f);
        } else if (-f5 > 2.0f) {
            f4 = resultPointArray[3].getX() - resultPointArray[7].getX();
            f3 = resultPointArray[3].getX() - resultPointArray[5].getX();
            f2 = resultPointArray[3].getY() - resultPointArray[5].getY();
            f = f4 * f2 / f3;
            resultPointArray[7] = new ResultPoint(resultPointArray[7].getX(), resultPointArray[7].getY() - f);
        }
    }

    private static float computeModuleWidth(ResultPoint[] resultPointArray) {
        float f = ResultPoint.distance(resultPointArray[0], resultPointArray[4]);
        float f2 = ResultPoint.distance(resultPointArray[1], resultPointArray[5]);
        float f3 = (f + f2) / 34.0f;
        float f4 = ResultPoint.distance(resultPointArray[6], resultPointArray[2]);
        float f5 = ResultPoint.distance(resultPointArray[7], resultPointArray[3]);
        float f6 = (f4 + f5) / 36.0f;
        return (f3 + f6) / 2.0f;
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, float f) {
        int n = Detector.round(ResultPoint.distance(resultPoint, resultPoint2) / f);
        int n2 = Detector.round(ResultPoint.distance(resultPoint3, resultPoint4) / f);
        return ((n + n2 >> 1) + 8) / 17 * 17;
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, n, 0.0f, 0.0f, n, 0.0f, n, n, 0.0f, n, resultPoint.getX(), resultPoint.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint4.getX(), resultPoint4.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private static int round(float f) {
        return (int)(f + 0.5f);
    }

    private static int[] findGuardPattern(BitMatrix bitMatrix, int n, int n2, int n3, boolean bl, int[] nArray) {
        int n4 = nArray.length;
        int[] nArray2 = new int[n4];
        boolean bl2 = bl;
        int n5 = 0;
        int n6 = n;
        for (int i = n; i < n + n3; ++i) {
            boolean bl3 = bitMatrix.get(i, n2);
            if (bl3 ^ bl2) {
                int n7 = n5;
                nArray2[n7] = nArray2[n7] + 1;
                continue;
            }
            if (n5 == n4 - 1) {
                if (Detector.patternMatchVariance(nArray2, nArray, 204) < 107) {
                    return new int[]{n6, i};
                }
                n6 += nArray2[0] + nArray2[1];
                for (int j = 2; j < n4; ++j) {
                    nArray2[j - 2] = nArray2[j];
                }
                nArray2[n4 - 2] = 0;
                nArray2[n4 - 1] = 0;
                --n5;
            } else {
                ++n5;
            }
            nArray2[n5] = 1;
            bl2 = !bl2;
        }
        return null;
    }

    private static int patternMatchVariance(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
            n5 += nArray2[n2];
        }
        if (n4 < n5) {
            return Integer.MAX_VALUE;
        }
        n2 = (n4 << 8) / n5;
        n = n * n2 >> 8;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            int n8 = nArray[i] << 8;
            int n9 = nArray2[i] * n2;
            int n10 = n7 = n8 > n9 ? n8 - n9 : n9 - n8;
            if (n7 > n) {
                return Integer.MAX_VALUE;
            }
            n6 += n7;
        }
        return n6 / n4;
    }
}

