/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.pdf417;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Reader;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DecoderResult;
import ai.com.google.zxing.common.DetectorResult;
import ai.com.google.zxing.pdf417.decoder.Decoder;
import ai.com.google.zxing.pdf417.detector.Detector;
import java.util.Hashtable;

public final class PDF417Reader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, FormatException {
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        if (hashtable != null && hashtable.containsKey(DecodeHintType.PURE_BARCODE)) {
            BitMatrix bitMatrix = PDF417Reader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode(bitMatrix);
            resultPointArray = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(binaryBitmap).detect();
            decoderResult = this.decoder.decode(detectorResult.getBits());
            resultPointArray = detectorResult.getPoints();
        }
        return new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.PDF_417);
    }

    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = PDF417Reader.moduleSize(nArray, bitMatrix);
        int n2 = nArray[1];
        int n3 = nArray2[1];
        int n4 = PDF417Reader.findPatternStart(nArray[0], n2, bitMatrix);
        int n5 = PDF417Reader.findPatternEnd(nArray[0], n2, bitMatrix);
        int n6 = (n5 - n4 + 1) / n;
        int n7 = (n3 - n2 + 1) / n;
        if (n6 == 0 || n7 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = n >> 1;
        n2 += n8;
        n4 += n8;
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        for (int i = 0; i < n7; ++i) {
            int n9 = n2 + i * n;
            for (int j = 0; j < n6; ++j) {
                if (!bitMatrix.get(n4 + j * n, n9)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }

    private static int moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int n2 = nArray[1];
        int n3 = bitMatrix.getWidth();
        for (n = nArray[0]; n < n3 && bitMatrix.get(n, n2); ++n) {
        }
        if (n == n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n4 = n - nArray[0] >>> 3;
        if (n4 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n4;
    }

    private static int findPatternStart(int n, int n2, BitMatrix bitMatrix) throws NotFoundException {
        int n3 = bitMatrix.getWidth();
        int n4 = n;
        int n5 = 0;
        boolean bl = true;
        while (n4 < n3 - 1 && n5 < 8) {
            boolean bl2;
            if (bl != (bl2 = bitMatrix.get(++n4, n2))) {
                ++n5;
            }
            bl = bl2;
        }
        if (n4 == n3 - 1) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n4;
    }

    private static int findPatternEnd(int n, int n2, BitMatrix bitMatrix) throws NotFoundException {
        int n3;
        int n4 = bitMatrix.getWidth();
        for (n3 = n4 - 1; n3 > n && !bitMatrix.get(n3, n2); --n3) {
        }
        int n5 = 0;
        boolean bl = true;
        while (n3 > n && n5 < 9) {
            boolean bl2;
            if (bl != (bl2 = bitMatrix.get(--n3, n2))) {
                ++n5;
            }
            bl = bl2;
        }
        if (n3 == n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n3;
    }
}

