/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.ReaderException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultMetadataType;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.ResultPointCallback;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.EANManufacturerOrgSupport;
import ai.com.google.zxing.oned.OneDReader;
import ai.com.google.zxing.oned.UPCEANExtensionSupport;
import java.util.Hashtable;

public abstract class UPCEANReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    static final int[] START_END_PATTERN;
    static final int[] MIDDLE_PATTERN;
    static final int[][] L_PATTERNS;
    static final int[][] L_AND_G_PATTERNS;
    private final StringBuffer decodeRowStringBuffer = new StringBuffer(20);
    private final UPCEANExtensionSupport extensionReader = new UPCEANExtensionSupport();
    private final EANManufacturerOrgSupport eanManSupport = new EANManufacturerOrgSupport();

    protected UPCEANReader() {
    }

    static int[] findStartGuardPattern(BitArray bitArray) throws NotFoundException {
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        while (!bl) {
            nArray = UPCEANReader.findGuardPattern(bitArray, n, false, START_END_PATTERN);
            int n2 = nArray[0];
            int n3 = n2 - ((n = nArray[1]) - n2);
            if (n3 < 0) continue;
            bl = bitArray.isRange(n3, n2, false);
        }
        return nArray;
    }

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(n, bitArray, UPCEANReader.findStartGuardPattern(bitArray), hashtable);
    }

    public Result decodeRow(int n, BitArray bitArray, int[] nArray, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        Object object;
        int n2;
        int n3;
        ResultPointCallback resultPointCallback;
        ResultPointCallback resultPointCallback2 = resultPointCallback = hashtable == null ? null : (ResultPointCallback)hashtable.get(DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n));
        }
        StringBuffer stringBuffer = this.decodeRowStringBuffer;
        stringBuffer.setLength(0);
        int n4 = this.decodeMiddle(bitArray, nArray, stringBuffer);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(n4, n));
        }
        int[] nArray2 = this.decodeEnd(bitArray, n4);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray2[0] + nArray2[1]) / 2.0f, n));
        }
        if ((n3 = (n2 = nArray2[1]) + (n2 - nArray2[0])) >= bitArray.getSize() || !bitArray.isRange(n2, n3, false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string = stringBuffer.toString();
        if (!this.checkChecksum(string)) {
            throw ChecksumException.getChecksumInstance();
        }
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        BarcodeFormat barcodeFormat = this.getBarcodeFormat();
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, barcodeFormat);
        try {
            object = this.extensionReader.decodeRow(n, bitArray, nArray2[1]);
            result.putAllMetadata(((Result)object).getResultMetadata());
            result.addResultPoints(((Result)object).getResultPoints());
        }
        catch (ReaderException readerException) {
            // empty catch block
        }
        if ((BarcodeFormat.EAN_13.equals(barcodeFormat) || BarcodeFormat.UPC_A.equals(barcodeFormat)) && (object = this.eanManSupport.lookupCountryIdentifier(string)) != null) {
            result.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, object);
        }
        return result;
    }

    boolean checkChecksum(String string) throws ChecksumException, FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(string);
    }

    private static boolean checkStandardUPCEANChecksum(String string) throws FormatException {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return false;
        }
        int n4 = 0;
        for (n2 = n3 - 2; n2 >= 0; n2 -= 2) {
            n = string.charAt(n2) - 48;
            if (n < 0 || n > 9) {
                throw FormatException.getFormatInstance();
            }
            n4 += n;
        }
        n4 *= 3;
        for (n2 = n3 - 1; n2 >= 0; n2 -= 2) {
            n = string.charAt(n2) - 48;
            if (n < 0 || n > 9) {
                throw FormatException.getFormatInstance();
            }
            n4 += n;
        }
        return n4 % 10 == 0;
    }

    int[] decodeEnd(BitArray bitArray, int n) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n, false, START_END_PATTERN);
    }

    static int[] findGuardPattern(BitArray bitArray, int n, boolean bl, int[] nArray) throws NotFoundException {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = bitArray.getSize();
        boolean bl2 = false;
        while (n < n3) {
            boolean bl3 = bl2 = !bitArray.get(n);
            if (bl == bl2) break;
            ++n;
        }
        int n4 = 0;
        int n5 = n;
        for (int i = n; i < n3; ++i) {
            boolean bl4 = bitArray.get(i);
            if (bl4 ^ bl2) {
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                continue;
            }
            if (n4 == n2 - 1) {
                if (UPCEANReader.patternMatchVariance(nArray2, nArray, 179) < 107) {
                    return new int[]{n5, i};
                }
                n5 += nArray2[0] + nArray2[1];
                for (int j = 2; j < n2; ++j) {
                    nArray2[j - 2] = nArray2[j];
                }
                nArray2[n2 - 2] = 0;
                nArray2[n2 - 1] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray2[n4] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n, int[][] nArray2) throws NotFoundException {
        UPCEANReader.recordPattern(bitArray, n, nArray);
        int n2 = 107;
        int n3 = -1;
        int n4 = nArray2.length;
        for (int i = 0; i < n4; ++i) {
            int[] nArray3 = nArray2[i];
            int n5 = UPCEANReader.patternMatchVariance(nArray, nArray3, 179);
            if (n5 >= n2) continue;
            n2 = n5;
            n3 = i;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuffer var3) throws NotFoundException;

    static {
        int n;
        START_END_PATTERN = new int[]{1, 1, 1};
        MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
        L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
        L_AND_G_PATTERNS = new int[20][];
        for (n = 0; n < 10; ++n) {
            UPCEANReader.L_AND_G_PATTERNS[n] = L_PATTERNS[n];
        }
        for (n = 10; n < 20; ++n) {
            int[] nArray = L_PATTERNS[n - 10];
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[nArray.length - i - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[n] = nArray2;
        }
    }
}

