/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultMetadataType;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

final class UPCEANExtensionSupport {
    private static final int[] EXTENSION_START_PATTERN = new int[]{1, 1, 2};
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuffer decodeRowStringBuffer = new StringBuffer();

    UPCEANExtensionSupport() {
    }

    Result decodeRow(int n, BitArray bitArray, int n2) throws NotFoundException {
        int[] nArray = UPCEANReader.findGuardPattern(bitArray, n2, false, EXTENSION_START_PATTERN);
        StringBuffer stringBuffer = this.decodeRowStringBuffer;
        stringBuffer.setLength(0);
        int n3 = this.decodeMiddle(bitArray, nArray, stringBuffer);
        String string = stringBuffer.toString();
        Hashtable hashtable = UPCEANExtensionSupport.parseExtensionString(string);
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n), new ResultPoint(n3, n)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (hashtable != null) {
            result.putAllMetadata(hashtable);
        }
        return result;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuffer stringBuffer) throws NotFoundException {
        int n;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n2 = bitArray.getSize();
        int n3 = nArray[1];
        int n4 = 0;
        for (n = 0; n < 5 && n3 < n2; ++n) {
            int n5 = UPCEANReader.decodeDigit(bitArray, nArray2, n3, UPCEANReader.L_AND_G_PATTERNS);
            stringBuffer.append((char)(48 + n5 % 10));
            for (int i = 0; i < nArray2.length; ++i) {
                n3 += nArray2[i];
            }
            if (n5 >= 10) {
                n4 |= 1 << 4 - n;
            }
            if (n == 4) continue;
            while (n3 < n2 && !bitArray.get(n3)) {
                ++n3;
            }
            while (n3 < n2 && bitArray.get(n3)) {
                ++n3;
            }
        }
        if (stringBuffer.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        n = UPCEANExtensionSupport.determineCheckDigit(n4);
        if (UPCEANExtensionSupport.extensionChecksum(stringBuffer.toString()) != n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n3;
    }

    private static int extensionChecksum(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = n2 - 2; n >= 0; n -= 2) {
            n3 += string.charAt(n) - 48;
        }
        n3 *= 3;
        for (n = n2 - 1; n >= 0; n -= 2) {
            n3 += string.charAt(n) - 48;
        }
        return (n3 *= 3) % 10;
    }

    private static int determineCheckDigit(int n) throws NotFoundException {
        for (int i = 0; i < 10; ++i) {
            if (n != CHECK_DIGIT_ENCODINGS[i]) continue;
            return i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Hashtable parseExtensionString(String string) {
        Object object;
        ResultMetadataType resultMetadataType;
        switch (string.length()) {
            case 2: {
                resultMetadataType = ResultMetadataType.ISSUE_NUMBER;
                object = UPCEANExtensionSupport.parseExtension2String(string);
                break;
            }
            case 5: {
                resultMetadataType = ResultMetadataType.SUGGESTED_PRICE;
                object = UPCEANExtensionSupport.parseExtension5String(string);
                break;
            }
            default: {
                return null;
            }
        }
        if (object == null) {
            return null;
        }
        Hashtable<ResultMetadataType, Object> hashtable = new Hashtable<ResultMetadataType, Object>(1);
        hashtable.put(resultMetadataType, object);
        return hashtable;
    }

    private static Integer parseExtension2String(String string) {
        return Integer.valueOf(string);
    }

    private static String parseExtension5String(String string) {
        String string2;
        switch (string.charAt(0)) {
            case '0': {
                string2 = "\u00a3";
                break;
            }
            case '5': {
                string2 = "$";
                break;
            }
            case '9': {
                if ("90000".equals(string)) {
                    return null;
                }
                if ("99991".equals(string)) {
                    return "0.00";
                }
                if ("99990".equals(string)) {
                    return "Used";
                }
                string2 = "";
                break;
            }
            default: {
                string2 = "";
            }
        }
        int n = Integer.parseInt(string.substring(1));
        String string3 = String.valueOf(n / 100);
        int n2 = n % 100;
        String string4 = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        return string2 + string3 + '.' + string4;
    }
}

