/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.EAN13Reader;
import ai.com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

public final class UPCAReader
extends UPCEANReader {
    private final UPCEANReader ean13Reader = new EAN13Reader();

    public Result decodeRow(int n, BitArray bitArray, int[] nArray, Hashtable hashtable) throws NotFoundException, FormatException, ChecksumException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(n, bitArray, nArray, hashtable));
    }

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException, FormatException, ChecksumException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(n, bitArray, hashtable));
    }

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(binaryBitmap));
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, FormatException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(binaryBitmap, hashtable));
    }

    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_A;
    }

    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuffer stringBuffer) throws NotFoundException {
        return this.ean13Reader.decodeMiddle(bitArray, nArray, stringBuffer);
    }

    private static Result maybeReturnResult(Result result) throws FormatException {
        String string = result.getText();
        if (string.charAt(0) == '0') {
            return new Result(string.substring(1), null, result.getResultPoints(), BarcodeFormat.UPC_A);
        }
        throw FormatException.getFormatInstance();
    }
}

