/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Reader;
import ai.com.google.zxing.ReaderException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.CodaBarReader;
import ai.com.google.zxing.oned.Code128Reader;
import ai.com.google.zxing.oned.Code39Reader;
import ai.com.google.zxing.oned.Code93Reader;
import ai.com.google.zxing.oned.ITFReader;
import ai.com.google.zxing.oned.MultiFormatUPCEANReader;
import ai.com.google.zxing.oned.OneDReader;
import ai.com.google.zxing.oned.rss.RSS14Reader;
import ai.com.google.zxing.oned.rss.expanded.RSSExpandedReader;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiFormatOneDReader
extends OneDReader {
    private final Vector readers;

    public MultiFormatOneDReader(Hashtable hashtable) {
        Vector vector = hashtable == null ? null : (Vector)hashtable.get(DecodeHintType.POSSIBLE_FORMATS);
        boolean bl = hashtable != null && hashtable.get(DecodeHintType.ASSUME_CODE_39_CHECK_DIGIT) != null;
        this.readers = new Vector();
        if (vector != null) {
            if (vector.contains(BarcodeFormat.EAN_13) || vector.contains(BarcodeFormat.UPC_A) || vector.contains(BarcodeFormat.EAN_8) || vector.contains(BarcodeFormat.UPC_E)) {
                this.readers.addElement(new MultiFormatUPCEANReader(hashtable));
            }
            if (vector.contains(BarcodeFormat.CODE_39)) {
                this.readers.addElement(new Code39Reader(bl));
            }
            if (vector.contains(BarcodeFormat.CODE_93)) {
                this.readers.addElement(new Code93Reader());
            }
            if (vector.contains(BarcodeFormat.CODE_128)) {
                this.readers.addElement(new Code128Reader());
            }
            if (vector.contains(BarcodeFormat.ITF)) {
                this.readers.addElement(new ITFReader());
            }
            if (vector.contains(BarcodeFormat.CODABAR)) {
                this.readers.addElement(new CodaBarReader());
            }
            if (vector.contains(BarcodeFormat.RSS_14)) {
                this.readers.addElement(new RSS14Reader());
            }
            if (vector.contains(BarcodeFormat.RSS_EXPANDED)) {
                this.readers.addElement(new RSSExpandedReader());
            }
        }
        if (this.readers.isEmpty()) {
            this.readers.addElement(new MultiFormatUPCEANReader(hashtable));
            this.readers.addElement(new Code39Reader());
            this.readers.addElement(new Code93Reader());
            this.readers.addElement(new Code128Reader());
            this.readers.addElement(new ITFReader());
            this.readers.addElement(new RSS14Reader());
            this.readers.addElement(new RSSExpandedReader());
        }
    }

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException {
        int n2 = this.readers.size();
        for (int i = 0; i < n2; ++i) {
            OneDReader oneDReader = (OneDReader)this.readers.elementAt(i);
            try {
                return oneDReader.decodeRow(n, bitArray, hashtable);
            }
            catch (ReaderException readerException) {
                continue;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public void reset() {
        int n = this.readers.size();
        for (int i = 0; i < n; ++i) {
            Reader reader = (Reader)this.readers.elementAt(i);
            reader.reset();
        }
    }
}

