/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuffer stringBuffer) throws NotFoundException {
        int n;
        int n2;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n3 = bitArray.getSize();
        int n4 = nArray[1];
        int n5 = 0;
        for (int i = 0; i < 6 && n4 < n3; ++i) {
            n2 = EAN13Reader.decodeDigit(bitArray, nArray2, n4, L_AND_G_PATTERNS);
            stringBuffer.append((char)(48 + n2 % 10));
            for (n = 0; n < nArray2.length; ++n) {
                n4 += nArray2[n];
            }
            if (n2 < 10) continue;
            n5 |= 1 << 5 - i;
        }
        EAN13Reader.determineFirstDigit(stringBuffer, n5);
        int[] nArray3 = EAN13Reader.findGuardPattern(bitArray, n4, true, MIDDLE_PATTERN);
        n4 = nArray3[1];
        for (n2 = 0; n2 < 6 && n4 < n3; ++n2) {
            n = EAN13Reader.decodeDigit(bitArray, nArray2, n4, L_PATTERNS);
            stringBuffer.append((char)(48 + n));
            for (int i = 0; i < nArray2.length; ++i) {
                n4 += nArray2[i];
            }
        }
        return n4;
    }

    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuffer stringBuffer, int n) throws NotFoundException {
        for (int i = 0; i < 10; ++i) {
            if (n != FIRST_DIGIT_ENCODINGS[i]) continue;
            stringBuffer.insert(0, (char)(48 + i));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

