/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class Code93Reader
extends OneDReader {
    private static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[47];

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        int n2;
        char c;
        int n3;
        int[] nArray = Code93Reader.findAsteriskPattern(bitArray);
        int n4 = bitArray.getSize();
        for (n3 = nArray[1]; n3 < n4 && !bitArray.get(n3); ++n3) {
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        int[] nArray2 = new int[6];
        do {
            Code93Reader.recordPattern(bitArray, n3, nArray2);
            int n5 = Code93Reader.toPattern(nArray2);
            if (n5 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c = Code93Reader.patternToChar(n5);
            stringBuffer.append(c);
            n2 = n3;
            for (int i = 0; i < nArray2.length; ++i) {
                n3 += nArray2[i];
            }
            while (n3 < n4 && !bitArray.get(n3)) {
                ++n3;
            }
        } while (c != '*');
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (n3 == n4 || !bitArray.get(n3)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (stringBuffer.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        Code93Reader.checkChecksums(stringBuffer);
        stringBuffer.setLength(stringBuffer.length() - 2);
        String string = Code93Reader.decodeExtended(stringBuffer);
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)(n3 + n2) / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODE_93);
    }

    private static int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n;
        int n2 = bitArray.getSize();
        for (n = 0; n < n2 && !bitArray.get(n); ++n) {
        }
        int n3 = 0;
        int[] nArray = new int[6];
        int n4 = n;
        boolean bl = false;
        int n5 = nArray.length;
        for (int i = n; i < n2; ++i) {
            boolean bl2 = bitArray.get(i);
            if (bl2 ^ bl) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n3 == n5 - 1) {
                if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                    return new int[]{n4, i};
                }
                n4 += nArray[0] + nArray[1];
                for (int j = 2; j < n5; ++j) {
                    nArray[j - 2] = nArray[j];
                }
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += nArray[n];
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = (nArray[i] << 8) * 9 / n3;
            int n5 = n4 >> 8;
            if ((n4 & 0xFF) > 127) {
                ++n5;
            }
            if (n5 < 1 || n5 > 4) {
                return -1;
            }
            if ((i & 1) == 0) {
                for (int j = 0; j < n5; ++j) {
                    n = n << 1 | 1;
                }
                continue;
            }
            n <<= n5;
        }
        return n;
    }

    private static char patternToChar(int n) throws NotFoundException {
        for (int i = 0; i < CHARACTER_ENCODINGS.length; ++i) {
            if (CHARACTER_ENCODINGS[i] != n) continue;
            return ALPHABET[i];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(StringBuffer stringBuffer) throws FormatException {
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c >= 'a' && c <= 'd') {
                char c2 = stringBuffer.charAt(i + 1);
                int n2 = 0;
                switch (c) {
                    case 'd': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'a': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'b': {
                        if (c2 >= 'A' && c2 <= 'E') {
                            n2 = (char)(c2 - 38);
                            break;
                        }
                        if (c2 >= 'F' && c2 <= 'W') {
                            n2 = (char)(c2 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'c': {
                        if (c2 >= 'A' && c2 <= 'O') {
                            n2 = (char)(c2 - 32);
                            break;
                        }
                        if (c2 == 'Z') {
                            n2 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuffer2.append((char)n2);
                ++i;
                continue;
            }
            stringBuffer2.append(c);
        }
        return stringBuffer2.toString();
    }

    private static void checkChecksums(StringBuffer stringBuffer) throws ChecksumException {
        int n = stringBuffer.length();
        Code93Reader.checkOneChecksum(stringBuffer, n - 2, 20);
        Code93Reader.checkOneChecksum(stringBuffer, n - 1, 15);
    }

    private static void checkOneChecksum(StringBuffer stringBuffer, int n, int n2) throws ChecksumException {
        int n3 = 1;
        int n4 = 0;
        for (int i = n - 1; i >= 0; --i) {
            n4 += n3 * ALPHABET_STRING.indexOf(stringBuffer.charAt(i));
            if (++n3 <= n2) continue;
            n3 = 1;
        }
        if (stringBuffer.charAt(n) != ALPHABET[n4 % 47]) {
            throw ChecksumException.getChecksumInstance();
        }
    }
}

