/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;

    public Code39Reader() {
        this.usingCheckDigit = false;
        this.extendedMode = false;
    }

    public Code39Reader(boolean bl) {
        this.usingCheckDigit = bl;
        this.extendedMode = false;
    }

    public Code39Reader(boolean bl, boolean bl2) {
        this.usingCheckDigit = bl;
        this.extendedMode = bl2;
    }

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException, ChecksumException, FormatException {
        int n2;
        int n3;
        int n4;
        char c;
        int n5;
        int[] nArray = Code39Reader.findAsteriskPattern(bitArray);
        int n6 = bitArray.getSize();
        for (n5 = nArray[1]; n5 < n6 && !bitArray.get(n5); ++n5) {
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        int[] nArray2 = new int[9];
        do {
            Code39Reader.recordPattern(bitArray, n5, nArray2);
            n4 = Code39Reader.toNarrowWidePattern(nArray2);
            if (n4 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c = Code39Reader.patternToChar(n4);
            stringBuffer.append(c);
            n3 = n5;
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                n5 += nArray2[n2];
            }
            while (n5 < n6 && !bitArray.get(n5)) {
                ++n5;
            }
        } while (c != '*');
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        n4 = 0;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            n4 += nArray2[n2];
        }
        n2 = n5 - n3 - n4;
        if (n5 != n6 && n2 / 2 < n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.usingCheckDigit) {
            int n7 = stringBuffer.length() - 1;
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                n8 += ALPHABET_STRING.indexOf(stringBuffer.charAt(i));
            }
            if (stringBuffer.charAt(n7) != ALPHABET[n8 % 43]) {
                throw ChecksumException.getChecksumInstance();
            }
            stringBuffer.deleteCharAt(n7);
        }
        if (stringBuffer.length() == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string = this.extendedMode ? Code39Reader.decodeExtended(stringBuffer) : stringBuffer.toString();
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)(n5 + n3) / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n;
        int n2 = bitArray.getSize();
        for (n = 0; n < n2 && !bitArray.get(n); ++n) {
        }
        int n3 = 0;
        int[] nArray = new int[9];
        int n4 = n;
        boolean bl = false;
        int n5 = nArray.length;
        for (int i = n; i < n2; ++i) {
            boolean bl2 = bitArray.get(i);
            if (bl2 ^ bl) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n3 == n5 - 1) {
                if (Code39Reader.toNarrowWidePattern(nArray) == ASTERISK_ENCODING && bitArray.isRange(Math.max(0, n4 - (i - n4) / 2), n4, false)) {
                    return new int[]{n4, i};
                }
                n4 += nArray[0] + nArray[1];
                for (int j = 2; j < n5; ++j) {
                    nArray[j - 2] = nArray[j];
                }
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = 0;
        do {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = Integer.MAX_VALUE;
            for (n7 = 0; n7 < n2; ++n7) {
                n6 = nArray[n7];
                if (n6 >= n8 || n6 <= n3) continue;
                n8 = n6;
            }
            n3 = n8;
            n = 0;
            n7 = 0;
            n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                n4 = nArray[n5];
                if (nArray[n5] <= n3) continue;
                n6 |= 1 << n2 - 1 - n5;
                ++n;
                n7 += n4;
            }
            if (n != 3) continue;
            for (n5 = 0; n5 < n2 && n > 0; ++n5) {
                n4 = nArray[n5];
                if (nArray[n5] <= n3) continue;
                --n;
                if (n4 << 1 < n7) continue;
                return -1;
            }
            return n6;
        } while (n > 3);
        return -1;
    }

    private static char patternToChar(int n) throws NotFoundException {
        for (int i = 0; i < CHARACTER_ENCODINGS.length; ++i) {
            if (CHARACTER_ENCODINGS[i] != n) continue;
            return ALPHABET[i];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(StringBuffer stringBuffer) throws FormatException {
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '+' || c == '$' || c == '%' || c == '/') {
                char c2 = stringBuffer.charAt(i + 1);
                int n2 = 0;
                switch (c) {
                    case '+': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '$': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '%': {
                        if (c2 >= 'A' && c2 <= 'E') {
                            n2 = (char)(c2 - 38);
                            break;
                        }
                        if (c2 >= 'F' && c2 <= 'W') {
                            n2 = (char)(c2 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '/': {
                        if (c2 >= 'A' && c2 <= 'O') {
                            n2 = (char)(c2 - 32);
                            break;
                        }
                        if (c2 == 'Z') {
                            n2 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuffer2.append((char)n2);
                ++i;
                continue;
            }
            stringBuffer2.append(c);
        }
        return stringBuffer2.toString();
    }
}

