/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public final class Code128Reader
extends OneDReader {
    static final int[][] CODE_PATTERNS = new int[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}, {2, 3, 3, 1, 1, 1, 2}};
    private static final int MAX_AVG_VARIANCE = 64;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    private static final int CODE_SHIFT = 98;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_STOP = 106;

    private static int[] findStartPattern(BitArray bitArray) throws NotFoundException {
        int n;
        int n2 = bitArray.getSize();
        for (n = 0; n < n2 && !bitArray.get(n); ++n) {
        }
        int n3 = 0;
        int[] nArray = new int[6];
        int n4 = n;
        boolean bl = false;
        int n5 = nArray.length;
        for (int i = n; i < n2; ++i) {
            boolean bl2 = bitArray.get(i);
            if (bl2 ^ bl) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n3 == n5 - 1) {
                int n7;
                int n8 = 64;
                int n9 = -1;
                for (n7 = 103; n7 <= 105; ++n7) {
                    int n10 = Code128Reader.patternMatchVariance(nArray, CODE_PATTERNS[n7], 179);
                    if (n10 >= n8) continue;
                    n8 = n10;
                    n9 = n7;
                }
                if (n9 >= 0 && bitArray.isRange(Math.max(0, n4 - (i - n4) / 2), n4, false)) {
                    return new int[]{n4, i, n9};
                }
                n4 += nArray[0] + nArray[1];
                for (n7 = 2; n7 < n5; ++n7) {
                    nArray[n7 - 2] = nArray[n7];
                }
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeCode(BitArray bitArray, int[] nArray, int n) throws NotFoundException {
        Code128Reader.recordPattern(bitArray, n, nArray);
        int n2 = 64;
        int n3 = -1;
        for (int i = 0; i < CODE_PATTERNS.length; ++i) {
            int[] nArray2 = CODE_PATTERNS[i];
            int n4 = Code128Reader.patternMatchVariance(nArray, nArray2, 179);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException, FormatException, ChecksumException {
        String string;
        int n2;
        int n3;
        int n4;
        int[] nArray = Code128Reader.findStartPattern(bitArray);
        int n5 = nArray[2];
        switch (n5) {
            case 103: {
                n4 = 101;
                break;
            }
            case 104: {
                n4 = 100;
                break;
            }
            case 105: {
                n4 = 99;
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        boolean bl = false;
        int n6 = 0;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n7 = nArray[0];
        int n8 = nArray[1];
        int[] nArray2 = new int[6];
        int n9 = 0;
        int n10 = 0;
        int n11 = n5;
        int n12 = 0;
        boolean bl2 = true;
        while (!bl) {
            n3 = n6;
            n6 = 0;
            n9 = n10;
            n10 = Code128Reader.decodeCode(bitArray, nArray2, n8);
            if (n10 != 106) {
                bl2 = true;
            }
            if (n10 != 106) {
                n11 += ++n12 * n10;
            }
            n7 = n8;
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                n8 += nArray2[n2];
            }
            switch (n10) {
                case 103: 
                case 104: 
                case 105: {
                    throw FormatException.getFormatInstance();
                }
            }
            block8 : switch (n4) {
                case 101: {
                    if (n10 < 64) {
                        stringBuffer.append((char)(32 + n10));
                        break;
                    }
                    if (n10 < 96) {
                        stringBuffer.append((char)(n10 - 64));
                        break;
                    }
                    if (n10 != 106) {
                        bl2 = false;
                    }
                    switch (n10) {
                        case 96: 
                        case 97: 
                        case 101: 
                        case 102: {
                            break;
                        }
                        case 98: {
                            n6 = 1;
                            n4 = 100;
                            break;
                        }
                        case 100: {
                            n4 = 100;
                            break;
                        }
                        case 99: {
                            n4 = 99;
                            break;
                        }
                        case 106: {
                            bl = true;
                        }
                    }
                    break;
                }
                case 100: {
                    if (n10 < 96) {
                        stringBuffer.append((char)(32 + n10));
                        break;
                    }
                    if (n10 != 106) {
                        bl2 = false;
                    }
                    switch (n10) {
                        case 96: 
                        case 97: 
                        case 100: 
                        case 102: {
                            break;
                        }
                        case 98: {
                            n6 = 1;
                            n4 = 101;
                            break;
                        }
                        case 101: {
                            n4 = 101;
                            break;
                        }
                        case 99: {
                            n4 = 99;
                            break;
                        }
                        case 106: {
                            bl = true;
                        }
                    }
                    break;
                }
                case 99: {
                    if (n10 < 100) {
                        if (n10 < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n10);
                        break;
                    }
                    if (n10 != 106) {
                        bl2 = false;
                    }
                    switch (n10) {
                        case 102: {
                            break block8;
                        }
                        case 101: {
                            n4 = 101;
                            break block8;
                        }
                        case 100: {
                            n4 = 100;
                            break block8;
                        }
                        case 106: {
                            bl = true;
                        }
                    }
                }
            }
            if (n3 == 0) continue;
            n4 = n4 == 101 ? 100 : 101;
        }
        n3 = bitArray.getSize();
        while (n8 < n3 && bitArray.get(n8)) {
            ++n8;
        }
        if (!bitArray.isRange(n8, Math.min(n3, n8 + (n8 - n7) / 2), false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((n11 -= n12 * n9) % 103 != n9) {
            throw ChecksumException.getChecksumInstance();
        }
        n2 = stringBuffer.length();
        if (n2 > 0 && bl2) {
            if (n4 == 99) {
                stringBuffer.delete(n2 - 2, n2);
            } else {
                stringBuffer.delete(n2 - 1, n2);
            }
        }
        if ((string = stringBuffer.toString()).length() == 0) {
            throw FormatException.getFormatInstance();
        }
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)(n8 + n7) / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODE_128);
    }
}

