/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.datamatrix.decoder;

import ai.com.google.zxing.ChecksumException;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DecoderResult;
import ai.com.google.zxing.common.reedsolomon.GenericGF;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonException;
import ai.com.google.zxing.datamatrix.decoder.BitMatrixParser;
import ai.com.google.zxing.datamatrix.decoder.DataBlock;
import ai.com.google.zxing.datamatrix.decoder.DecodedBitStreamParser;
import ai.com.google.zxing.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) throws FormatException, ChecksumException {
        int n = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!blArray[i][j]) continue;
                bitMatrix.set(j, i);
            }
        }
        return this.decode(bitMatrix);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        Version version = bitMatrixParser.getVersion();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version);
        int n = dataBlockArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += dataBlockArray[i].getNumDataCodewords();
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n; ++i) {
            DataBlock dataBlock = dataBlockArray[i];
            byte[] byArray3 = dataBlock.getCodewords();
            int n3 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray3, n3);
            for (int j = 0; j < n3; ++j) {
                byArray2[j * n + i] = byArray3[j];
            }
        }
        return DecodedBitStreamParser.decode(byArray2);
    }

    private void correctErrors(byte[] byArray, int n) throws ChecksumException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = byArray.length - n;
        try {
            this.rsDecoder.decode(nArray, n2);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)nArray[i];
        }
    }
}

