/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.result.optional;

import ai.com.google.zxing.Result;
import ai.com.google.zxing.client.result.TextParsedResult;
import ai.com.google.zxing.client.result.optional.AbstractNDEFResultParser;
import ai.com.google.zxing.client.result.optional.NDEFRecord;

final class NDEFTextResultParser
extends AbstractNDEFResultParser {
    NDEFTextResultParser() {
    }

    public static TextParsedResult parse(Result result) {
        byte[] byArray = result.getRawBytes();
        if (byArray == null) {
            return null;
        }
        NDEFRecord nDEFRecord = NDEFRecord.readRecord(byArray, 0);
        if (nDEFRecord == null || !nDEFRecord.isMessageBegin() || !nDEFRecord.isMessageEnd()) {
            return null;
        }
        if (!nDEFRecord.getType().equals("T")) {
            return null;
        }
        String[] stringArray = NDEFTextResultParser.decodeTextPayload(nDEFRecord.getPayload());
        return new TextParsedResult(stringArray[0], stringArray[1]);
    }

    static String[] decodeTextPayload(byte[] byArray) {
        byte by = byArray[0];
        boolean bl = (by & 0x80) != 0;
        int n = by & 0x1F;
        String string = NDEFTextResultParser.bytesToString(byArray, 1, n, "US-ASCII");
        String string2 = bl ? "UTF-16" : "UTF8";
        String string3 = NDEFTextResultParser.bytesToString(byArray, 1 + n, byArray.length - n - 1, string2);
        return new String[]{string, string3};
    }
}

