/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.j2se;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.client.j2se.Config;
import ai.com.google.zxing.client.j2se.DecodeThread;
import ai.com.google.zxing.client.j2se.Inputs;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLineRunner {
    private CommandLineRunner() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        int n2;
        if (stringArray == null || stringArray.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        Inputs inputs = new Inputs();
        for (String string : stringArray) {
            if ("--try_harder".equals(string)) {
                config.setTryHarder(true);
                continue;
            }
            if ("--pure_barcode".equals(string)) {
                config.setPureBarcode(true);
                continue;
            }
            if ("--products_only".equals(string)) {
                config.setProductsOnly(true);
                continue;
            }
            if ("--dump_results".equals(string)) {
                config.setDumpResults(true);
                continue;
            }
            if ("--dump_black_point".equals(string)) {
                config.setDumpBlackPoint(true);
                continue;
            }
            if ("--multi".equals(string)) {
                config.setMulti(true);
                continue;
            }
            if ("--brief".equals(string)) {
                config.setBrief(true);
                continue;
            }
            if ("--recursive".equals(string)) {
                config.setRecursive(true);
                continue;
            }
            if (string.startsWith("--crop")) {
                int[] nArray = new int[4];
                String[] stringArray2 = string.substring(7).split(",");
                for (int i = 0; i < config.getCrop().length; ++i) {
                    nArray[i] = Integer.parseInt(stringArray2[i]);
                }
                config.setCrop(nArray);
                continue;
            }
            if (string.startsWith("--threads") && string.length() >= 10) {
                int n3 = Integer.parseInt(string.substring(10));
                if (n3 <= 1) continue;
                config.setThreads(n3);
                continue;
            }
            if (!string.startsWith("-")) continue;
            System.err.println("Unknown command line option " + string);
            CommandLineRunner.printUsage();
            return;
        }
        config.setHints(CommandLineRunner.buildHints(config));
        for (String string : stringArray) {
            if (string.startsWith("--")) continue;
            CommandLineRunner.addArgumentToInputs(string, config, inputs);
        }
        ArrayList arrayList = new ArrayList(config.getThreads());
        for (n2 = 0; n2 < config.getThreads(); ++n2) {
            DecodeThread decodeThread = new DecodeThread(config, inputs);
            arrayList.add(decodeThread);
            decodeThread.start();
        }
        n2 = 0;
        for (n = 0; n < config.getThreads(); ++n) {
            ((DecodeThread)arrayList.get(n)).join();
            n2 += ((DecodeThread)arrayList.get(n)).getSuccessful();
        }
        n = inputs.getInputCount();
        if (n > 1) {
            System.out.println("\nDecoded " + n2 + " files out of " + n + " successfully (" + n2 * 100 / n + "%)\n");
        }
    }

    private static void addArgumentToInputs(String string, Config config, Inputs inputs) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    String string2 = file2.getName().toLowerCase(Locale.ENGLISH);
                    if (string2.startsWith(".")) continue;
                    if (file2.isDirectory()) {
                        if (!config.isRecursive()) continue;
                        CommandLineRunner.addArgumentToInputs(file2.getAbsolutePath(), config, inputs);
                        continue;
                    }
                    if (string2.endsWith(".txt") || string2.contains(".mono.png")) continue;
                    inputs.addInput(file2.getAbsolutePath());
                }
            } else {
                inputs.addInput(file.getAbsolutePath());
            }
        } else {
            inputs.addInput(string);
        }
    }

    private static Hashtable<DecodeHintType, Object> buildHints(Config config) {
        Hashtable<DecodeHintType, Object> hashtable = new Hashtable<DecodeHintType, Object>(3);
        Vector<BarcodeFormat> vector = new Vector<BarcodeFormat>(8);
        vector.addElement(BarcodeFormat.UPC_A);
        vector.addElement(BarcodeFormat.UPC_E);
        vector.addElement(BarcodeFormat.EAN_13);
        vector.addElement(BarcodeFormat.EAN_8);
        vector.addElement(BarcodeFormat.RSS_14);
        vector.addElement(BarcodeFormat.RSS_EXPANDED);
        if (!config.isProductsOnly()) {
            vector.addElement(BarcodeFormat.CODE_39);
            vector.addElement(BarcodeFormat.CODE_93);
            vector.addElement(BarcodeFormat.CODE_128);
            vector.addElement(BarcodeFormat.ITF);
            vector.addElement(BarcodeFormat.QR_CODE);
            vector.addElement(BarcodeFormat.DATA_MATRIX);
            vector.addElement(BarcodeFormat.AZTEC);
            vector.addElement(BarcodeFormat.PDF_417);
            vector.addElement(BarcodeFormat.CODABAR);
        }
        hashtable.put(DecodeHintType.POSSIBLE_FORMATS, vector);
        if (config.isTryHarder()) {
            hashtable.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            hashtable.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hashtable;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        System.err.println("  --threads=n: The number of threads to use while decoding");
    }
}

