/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.aztec.decoder;

import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.aztec.AztecDetectorResult;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DecoderResult;
import ai.com.google.zxing.common.reedsolomon.GenericGF;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class Decoder {
    private static final int UPPER = 0;
    private static final int LOWER = 1;
    private static final int MIXED = 2;
    private static final int DIGIT = 3;
    private static final int PUNCT = 4;
    private static final int BINARY = 5;
    private static final int[] NB_BITS_COMPACT = new int[]{0, 104, 240, 408, 608};
    private static final int[] NB_BITS = new int[]{0, 128, 288, 480, 704, 960, 1248, 1568, 1920, 2304, 2720, 3168, 3648, 4160, 4704, 5280, 5888, 6528, 7200, 7904, 8640, 9408, 10208, 11040, 11904, 12800, 13728, 14688, 15680, 16704, 17760, 18848, 19968};
    private static final int[] NB_DATABLOCK_COMPACT = new int[]{0, 17, 40, 51, 76};
    private static final int[] NB_DATABLOCK = new int[]{0, 21, 48, 60, 88, 120, 156, 196, 240, 230, 272, 316, 364, 416, 470, 528, 588, 652, 720, 790, 864, 940, 1020, 920, 992, 1066, 1144, 1224, 1306, 1392, 1480, 1570, 1664};
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private int numCodewords;
    private int codewordSize;
    private AztecDetectorResult ddata;
    private int invertedBitCount;

    public DecoderResult decode(AztecDetectorResult aztecDetectorResult) throws FormatException {
        this.ddata = aztecDetectorResult;
        BitMatrix bitMatrix = aztecDetectorResult.getBits();
        if (!this.ddata.isCompact()) {
            bitMatrix = Decoder.removeDashedLines(this.ddata.getBits());
        }
        boolean[] blArray = this.extractBits(bitMatrix);
        boolean[] blArray2 = this.correctBits(blArray);
        String string = this.getEncodedData(blArray2);
        return new DecoderResult(null, string, null, null);
    }

    private String getEncodedData(boolean[] blArray) throws FormatException {
        int n = this.codewordSize * this.ddata.getNbDatablocks() - this.invertedBitCount;
        if (n > blArray.length) {
            throw FormatException.getFormatInstance();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(20);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl) {
            if (bl2) {
                bl3 = true;
            } else {
                n2 = n3;
            }
            switch (n3) {
                case 5: {
                    if (n - n4 < 8) {
                        bl = true;
                        break;
                    }
                    int n5 = Decoder.readCode(blArray, n4, 8);
                    n4 += 8;
                    stringBuffer.append((char)n5);
                    break;
                }
                default: {
                    int n6 = 5;
                    if (n3 == 3) {
                        n6 = 4;
                    }
                    if (n - n4 < n6) {
                        bl = true;
                        break;
                    }
                    int n5 = Decoder.readCode(blArray, n4, n6);
                    n4 += n6;
                    String string = Decoder.getCharacter(n3, n5);
                    if (string.startsWith("CTRL_")) {
                        n3 = Decoder.getTable(string.charAt(5));
                        if (string.charAt(6) != 'S') break;
                        bl2 = true;
                        break;
                    }
                    stringBuffer.append(string);
                }
            }
            if (!bl3) continue;
            n3 = n2;
            bl2 = false;
            bl3 = false;
        }
        return stringBuffer.toString();
    }

    private static int getTable(char c) {
        int n = 0;
        switch (c) {
            case 'U': {
                n = 0;
                break;
            }
            case 'L': {
                n = 1;
                break;
            }
            case 'P': {
                n = 4;
                break;
            }
            case 'M': {
                n = 2;
                break;
            }
            case 'D': {
                n = 3;
                break;
            }
            case 'B': {
                n = 5;
            }
        }
        return n;
    }

    private static String getCharacter(int n, int n2) {
        switch (n) {
            case 0: {
                return UPPER_TABLE[n2];
            }
            case 1: {
                return LOWER_TABLE[n2];
            }
            case 2: {
                return MIXED_TABLE[n2];
            }
            case 4: {
                return PUNCT_TABLE[n2];
            }
            case 3: {
                return DIGIT_TABLE[n2];
            }
        }
        return "";
    }

    private boolean[] correctBits(boolean[] blArray) throws FormatException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        GenericGF genericGF;
        if (this.ddata.getNbLayers() <= 2) {
            this.codewordSize = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            this.codewordSize = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            this.codewordSize = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            this.codewordSize = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n5 = this.ddata.getNbDatablocks();
        if (this.ddata.isCompact()) {
            n4 = NB_BITS_COMPACT[this.ddata.getNbLayers()] - this.numCodewords * this.codewordSize;
            n3 = NB_DATABLOCK_COMPACT[this.ddata.getNbLayers()] - n5;
        } else {
            n4 = NB_BITS[this.ddata.getNbLayers()] - this.numCodewords * this.codewordSize;
            n3 = NB_DATABLOCK[this.ddata.getNbLayers()] - n5;
        }
        int[] nArray = new int[this.numCodewords];
        for (int i = 0; i < this.numCodewords; ++i) {
            n2 = 1;
            for (n = 1; n <= this.codewordSize; ++n) {
                if (blArray[this.codewordSize * i + this.codewordSize - n + n4]) {
                    int n6 = i;
                    nArray[n6] = nArray[n6] + n2;
                }
                n2 <<= 1;
            }
        }
        try {
            object = new ReedSolomonDecoder(genericGF);
            ((ReedSolomonDecoder)object).decode(nArray, n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw FormatException.getFormatInstance();
        }
        n4 = 0;
        this.invertedBitCount = 0;
        object = new boolean[n5 * this.codewordSize];
        for (n2 = 0; n2 < n5; ++n2) {
            n = 0;
            int n7 = 0;
            int n8 = 1 << this.codewordSize - 1;
            for (int i = 0; i < this.codewordSize; ++i) {
                int n9;
                int n10 = n9 = (nArray[n2] & n8) == n8 ? 1 : 0;
                if (n7 == this.codewordSize - 1) {
                    if (n9 == n) {
                        throw FormatException.getFormatInstance();
                    }
                    n = 0;
                    n7 = 0;
                    ++n4;
                    ++this.invertedBitCount;
                } else {
                    if (n == n9) {
                        ++n7;
                    } else {
                        n7 = 1;
                        n = n9;
                    }
                    object[n2 * this.codewordSize + i - n4] = n9;
                }
                n8 >>>= 1;
            }
        }
        return object;
    }

    private boolean[] extractBits(BitMatrix bitMatrix) throws FormatException {
        boolean[] blArray;
        if (this.ddata.isCompact()) {
            if (this.ddata.getNbLayers() > NB_BITS_COMPACT.length) {
                throw FormatException.getFormatInstance();
            }
            blArray = new boolean[NB_BITS_COMPACT[this.ddata.getNbLayers()]];
            this.numCodewords = NB_DATABLOCK_COMPACT[this.ddata.getNbLayers()];
        } else {
            if (this.ddata.getNbLayers() > NB_BITS.length) {
                throw FormatException.getFormatInstance();
            }
            blArray = new boolean[NB_BITS[this.ddata.getNbLayers()]];
            this.numCodewords = NB_DATABLOCK[this.ddata.getNbLayers()];
        }
        int n = this.ddata.getNbLayers();
        int n2 = bitMatrix.height;
        int n3 = 0;
        int n4 = 0;
        while (n != 0) {
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 < 2 * n2 - 4; ++n5) {
                blArray[n3 + n5] = bitMatrix.get(n4 + n6, n4 + n5 / 2);
                blArray[n3 + 2 * n2 - 4 + n5] = bitMatrix.get(n4 + n5 / 2, n4 + n2 - 1 - n6);
                n6 = (n6 + 1) % 2;
            }
            n6 = 0;
            for (n5 = 2 * n2 + 1; n5 > 5; --n5) {
                blArray[n3 + 4 * n2 - 8 + (2 * n2 - n5) + 1] = bitMatrix.get(n4 + n2 - 1 - n6, n4 + n5 / 2 - 1);
                blArray[n3 + 6 * n2 - 12 + (2 * n2 - n5) + 1] = bitMatrix.get(n4 + n5 / 2 - 1, n4 + n6);
                n6 = (n6 + 1) % 2;
            }
            n4 += 2;
            n3 += 8 * n2 - 16;
            --n;
            n2 -= 4;
        }
        return blArray;
    }

    private static BitMatrix removeDashedLines(BitMatrix bitMatrix) {
        int n = 1 + 2 * ((bitMatrix.width - 1) / 2 / 16);
        BitMatrix bitMatrix2 = new BitMatrix(bitMatrix.width - n, bitMatrix.height - n);
        int n2 = 0;
        for (int i = 0; i < bitMatrix.width; ++i) {
            if ((bitMatrix.width / 2 - i) % 16 == 0) continue;
            int n3 = 0;
            for (int j = 0; j < bitMatrix.height; ++j) {
                if ((bitMatrix.width / 2 - j) % 16 == 0) continue;
                if (bitMatrix.get(i, j)) {
                    bitMatrix2.set(n2, n3);
                }
                ++n3;
            }
            ++n2;
        }
        return bitMatrix2;
    }

    private static int readCode(boolean[] blArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 <<= 1;
            if (!blArray[i]) continue;
            ++n3;
        }
        return n3;
    }
}

