/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.aztec;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.FormatException;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Reader;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultMetadataType;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.ResultPointCallback;
import ai.com.google.zxing.aztec.AztecDetectorResult;
import ai.com.google.zxing.aztec.decoder.Decoder;
import ai.com.google.zxing.aztec.detector.Detector;
import ai.com.google.zxing.common.DecoderResult;
import java.util.Hashtable;

public final class AztecReader
implements Reader {
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException, FormatException {
        Object object;
        AztecDetectorResult aztecDetectorResult = new Detector(binaryBitmap.getBlackMatrix()).detect();
        ResultPoint[] resultPointArray = aztecDetectorResult.getPoints();
        if (hashtable != null && aztecDetectorResult.getPoints() != null && (object = (ResultPointCallback)hashtable.get(DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            for (int i = 0; i < aztecDetectorResult.getPoints().length; ++i) {
                object.foundPossibleResultPoint(aztecDetectorResult.getPoints()[i]);
            }
        }
        object = new Decoder().decode(aztecDetectorResult);
        Result result = new Result(((DecoderResult)object).getText(), ((DecoderResult)object).getRawBytes(), resultPointArray, BarcodeFormat.AZTEC);
        if (((DecoderResult)object).getByteSegments() != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, ((DecoderResult)object).getByteSegments());
        }
        if (((DecoderResult)object).getECLevel() != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ((DecoderResult)object).getECLevel().toString());
        }
        return result;
    }

    public void reset() {
    }
}

