/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringsResourceTranslator {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<string name=\"([^\"]+)\">([^<]+)</string>");
    private static final Pattern STRINGS_FILE_NAME_PATTERN = Pattern.compile("values-(.+)");
    private static final Pattern TRANSLATE_RESPONSE_PATTERN = Pattern.compile("\\{\"translatedText\":\"([^\"]+)\"\\}");
    private static final String APACHE_2_LICENSE = "<!--\n Copyright (C) 2010 ZXing authors\n\n Licensed under the Apache License, Version 2.0 (the \"License\");\n you may not use this file except in compliance with the License.\n You may obtain a copy of the License at\n\n      http://www.apache.org/licenses/LICENSE-2.0\n\n Unless required by applicable law or agreed to in writing, software\n distributed under the License is distributed on an \"AS IS\" BASIS,\n WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n See the License for the specific language governing permissions and\n limitations under the License.\n -->\n";
    private static final Map<String, String> LANGUAGE_CODE_MASSAGINGS = new HashMap<String, String>(7);

    private StringsResourceTranslator() {
    }

    public static void main(String[] stringArray) throws IOException {
        File[] fileArray;
        File file = new File(stringArray[0]);
        File file2 = new File(file, "values");
        File file3 = new File(file2, "strings.xml");
        List<String> list = Arrays.asList(stringArray).subList(1, stringArray.length);
        for (File file4 : fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("values-");
            }
        })) {
            File file5 = new File(file4, "strings.xml");
            StringsResourceTranslator.translate(file3, file5, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translate(File file, File file2, Collection<String> collection) throws IOException {
        SortedMap<String, String> sortedMap = StringsResourceTranslator.readLines(file);
        SortedMap<String, String> sortedMap2 = StringsResourceTranslator.readLines(file2);
        String string = file2.getParentFile().getName();
        Matcher matcher = STRINGS_FILE_NAME_PATTERN.matcher(string);
        matcher.find();
        String string2 = matcher.group(1);
        String string3 = LANGUAGE_CODE_MASSAGINGS.get(string2);
        if (string3 != null) {
            string2 = string3;
        }
        System.out.println("Translating " + string2);
        File file3 = File.createTempFile(string, ".xml");
        boolean bl = false;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file3), UTF8);
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            outputStreamWriter.write(APACHE_2_LICENSE);
            outputStreamWriter.write("<resources>\n");
            for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
                String string4 = entry.getKey();
                outputStreamWriter.write("  <string name=\"");
                outputStreamWriter.write(string4);
                outputStreamWriter.write("\">");
                String string5 = (String)sortedMap2.get(string4);
                if (string5 == null || collection.contains(string4)) {
                    bl = true;
                    string5 = StringsResourceTranslator.translateString(entry.getValue(), string2);
                }
                outputStreamWriter.write(string5);
                outputStreamWriter.write("</string>\n");
            }
            outputStreamWriter.write("</resources>\n");
            ((Writer)outputStreamWriter).flush();
        }
        catch (Throwable throwable) {
            StringsResourceTranslator.quietClose(outputStreamWriter);
            throw throwable;
        }
        StringsResourceTranslator.quietClose(outputStreamWriter);
        if (bl) {
            System.out.println("  Writing translations");
            file2.delete();
            file3.renameTo(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String translateString(String string, String string2) throws IOException {
        Object object;
        System.out.println("  Need translation for " + string);
        URL uRL = new URL("http://ajax.googleapis.com/ajax/services/language/translate?v=1.0&q=" + URLEncoder.encode(string, "UTF-8") + "&langpair=en%7C" + string2);
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            inputStreamReader = new InputStreamReader(uRL.openStream(), UTF8);
            object = new char[1024];
            while ((n = inputStreamReader.read((char[])object)) > 0) {
                stringBuilder.append((char[])object, 0, n);
            }
        }
        catch (Throwable throwable) {
            StringsResourceTranslator.quietClose(inputStreamReader);
            throw throwable;
        }
        StringsResourceTranslator.quietClose(inputStreamReader);
        object = TRANSLATE_RESPONSE_PATTERN.matcher(stringBuilder);
        if (!((Matcher)object).find()) {
            throw new IOException("No translate result");
        }
        String string3 = ((Matcher)object).group(1);
        System.out.println("  Got translation " + string3);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SortedMap<String, String> readLines(File file) throws IOException {
        Object object;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8));
            while ((string = bufferedReader.readLine()) != null) {
                object = ENTRY_PATTERN.matcher(string);
                if (!((Matcher)object).find()) continue;
                String string2 = ((Matcher)object).group(1);
                String string3 = ((Matcher)object).group(2);
                treeMap.put(string2, string3);
            }
            object = treeMap;
        }
        catch (Throwable throwable) {
            StringsResourceTranslator.quietClose(bufferedReader);
            throw throwable;
        }
        StringsResourceTranslator.quietClose(bufferedReader);
        return object;
    }

    private static void quietClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        LANGUAGE_CODE_MASSAGINGS.put("ja-rJP", "ja");
        LANGUAGE_CODE_MASSAGINGS.put("zh-rCN", "zh-cn");
        LANGUAGE_CODE_MASSAGINGS.put("zh-rTW", "zh-tw");
        LANGUAGE_CODE_MASSAGINGS.put("kr", "ko");
    }
}

