/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.StandardXYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYBarPainter;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYSeries;
import ai.org.jfree.data.xy.XYSeriesCollection;
import ai.org.jfree.ui.RectangleInsets;
import com.activeintra.aichart.AIChartModule;
import com.activeintra.aichart.CustomXYBarRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class XYBarChart
extends AIChartModule {
    public String toString() {
        return "1. XY Bar Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        int n2 = this.data.length % 2;
        if (n2 != 0 || this.data.length < 2) {
            return this.getErrorChart();
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i = 0; i < this.series.length; i += 2) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)this.series[i]));
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                double d2 = this.data[i + 1][j];
                xYSeries.add(d, d2);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        return this.createChart((IntervalXYDataset)xYSeriesCollection);
    }

    public JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYBarChart((String)"", (String)"", (boolean)false, (String)"", (IntervalXYDataset)intervalXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)new Color(225, 225, 225));
        jFreeChart.setBorderVisible(true);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setNoDataMessage("NO DATA!");
        xYPlot.setBackgroundPaint(null);
        xYPlot.setInsets(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        xYPlot.setOutlinePaint((Paint)Color.black);
        xYPlot.setRangeGridlinesVisible(true);
        xYPlot.setRangeGridlinePaint((Paint)new Color(112, 112, 112));
        BasicStroke basicStroke = new BasicStroke(0.1f);
        xYPlot.setRangeGridlineStroke((Stroke)basicStroke);
        xYPlot.setRangePannable(true);
        xYPlot.setBackgroundPaint((Paint)Color.white);
        Paint[] paintArray = this.createPaint();
        CustomXYBarRenderer customXYBarRenderer = new CustomXYBarRenderer(paintArray, true);
        customXYBarRenderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        customXYBarRenderer.setDrawBarOutline(true);
        customXYBarRenderer.setBaseOutlinePaint(new Color(41, 41, 41));
        customXYBarRenderer.setBaseOutlineStroke(new BasicStroke(0.7f));
        customXYBarRenderer.setShadowVisible(false);
        xYPlot.setRenderer((XYItemRenderer)customXYBarRenderer);
        return jFreeChart;
    }

    private Paint[] createPaint() {
        Paint[] paintArray = new Paint[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            paintArray[i] = new Color(this.colorArray[i]);
        }
        return paintArray;
    }
}

