/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.plot.PolarPlot;
import ai.org.jfree.chart.renderer.DefaultPolarItemRenderer;
import ai.org.jfree.chart.renderer.PolarItemRenderer;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.data.xy.XYSeries;
import ai.org.jfree.data.xy.XYSeriesCollection;
import com.activeintra.aichart.AIChartModule;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class PolarChart
extends AIChartModule {
    public String toString() {
        return "1. Polar Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i = 0; i < this.series.length; i += 2) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)this.series[i]));
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                double d2 = this.data[i + 1][j];
                xYSeries.add(d, d2);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        return this.createChart((IntervalXYDataset)xYSeriesCollection);
    }

    public JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createPolarChart((String)"", (XYDataset)intervalXYDataset, (boolean)false, (boolean)false, (boolean)false);
        jFreeChart.setBorderVisible(true);
        PolarPlot polarPlot = (PolarPlot)jFreeChart.getPlot();
        polarPlot.setOutlineVisible(true);
        NumberAxis numberAxis = (NumberAxis)polarPlot.getAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        DefaultPolarItemRenderer defaultPolarItemRenderer = new DefaultPolarItemRenderer();
        for (int i = 0; i < this.series.length; ++i) {
            defaultPolarItemRenderer.setSeriesPaint(i, (Paint)new Color(this.colorArray[i]));
            defaultPolarItemRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        polarPlot.setRenderer((PolarItemRenderer)defaultPolarItemRenderer);
        return jFreeChart;
    }
}

