/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarPainter;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.StackedBarRenderer;
import ai.org.jfree.chart.renderer.category.StandardBarPainter;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.DefaultCategoryDataset;
import ai.org.jfree.ui.GradientPaintTransformType;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import com.activeintra.aichart.AIChartModule;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;

public class PercentageStackedBarChart
extends AIChartModule {
    public String toString() {
        return "3. Percentage StackedBar Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.series.length; ++i) {
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                defaultCategoryDataset.addValue(d, (Comparable)((Object)this.series[i]), (Comparable)((Object)this.labels[j]));
            }
        }
        return this.createChart((CategoryDataset)defaultCategoryDataset);
    }

    public JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)new Color(225, 225, 225));
        jFreeChart.setBorderVisible(true);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        categoryPlot.setBackgroundPaint(null);
        categoryPlot.setOutlinePaint((Paint)Color.black);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)new Color(112, 112, 112));
        BasicStroke basicStroke = new BasicStroke(0.1f);
        categoryPlot.setRangeGridlineStroke((Stroke)basicStroke);
        categoryPlot.setRangePannable(true);
        categoryPlot.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setForegroundAlpha(1.0f);
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        stackedBarRenderer.setBarPainter((BarPainter)new StandardBarPainter());
        stackedBarRenderer.setDrawBarOutline(true);
        stackedBarRenderer.setBaseOutlinePaint((Paint)Color.black);
        stackedBarRenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        stackedBarRenderer.setRenderAsPercentages(true);
        for (int i = 0; i < this.series.length; ++i) {
            Color color = new Color(this.colorArray[i]);
            stackedBarRenderer.setSeriesPaint(i, (Paint)color);
        }
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
        return jFreeChart;
    }

    private Paint[] createPaint() {
        Paint[] paintArray = new Paint[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            paintArray[i] = new Color(this.colorArray[0]);
        }
        return paintArray;
    }

    class CustomBarRenderer
    extends BarRenderer {
        private Paint[] colors;

        public Paint getItemPaint(int n, int n2) {
            return this.colors[n2 % this.colors.length];
        }

        public CustomBarRenderer(Paint[] paintArray) {
            this.colors = paintArray;
        }
    }
}

