/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class PaintAlpha {
    private static final double FACTOR = 0.7;
    private static boolean legacyAlpha = false;

    public static boolean setLegacyAlpha(boolean bl) {
        boolean bl2 = legacyAlpha;
        legacyAlpha = bl;
        return bl2;
    }

    public static Paint darker(Paint paint) {
        if (paint instanceof Color) {
            return PaintAlpha.darker((Color)paint);
        }
        if (legacyAlpha) {
            return paint;
        }
        if (paint instanceof GradientPaint) {
            return PaintAlpha.darker((GradientPaint)paint);
        }
        if (paint instanceof LinearGradientPaint) {
            return PaintAlpha.darkerLinearGradientPaint((LinearGradientPaint)paint);
        }
        if (paint instanceof RadialGradientPaint) {
            return PaintAlpha.darkerRadialGradientPaint((RadialGradientPaint)paint);
        }
        if (paint instanceof TexturePaint) {
            try {
                return PaintAlpha.darkerTexturePaint((TexturePaint)paint);
            }
            catch (Exception exception) {
                return paint;
            }
        }
        return paint;
    }

    private static Color darker(Color color) {
        return new Color((int)((double)color.getRed() * 0.7), (int)((double)color.getGreen() * 0.7), (int)((double)color.getBlue() * 0.7), color.getAlpha());
    }

    private static GradientPaint darker(GradientPaint gradientPaint) {
        return new GradientPaint(gradientPaint.getPoint1(), PaintAlpha.darker(gradientPaint.getColor1()), gradientPaint.getPoint2(), PaintAlpha.darker(gradientPaint.getColor2()), gradientPaint.isCyclic());
    }

    private static Paint darkerLinearGradientPaint(LinearGradientPaint linearGradientPaint) {
        Color[] colorArray = linearGradientPaint.getColors();
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = PaintAlpha.darker(colorArray[i]);
        }
        return new LinearGradientPaint(linearGradientPaint.getStartPoint(), linearGradientPaint.getEndPoint(), linearGradientPaint.getFractions(), colorArray, linearGradientPaint.getCycleMethod(), linearGradientPaint.getColorSpace(), linearGradientPaint.getTransform());
    }

    private static Paint darkerRadialGradientPaint(RadialGradientPaint radialGradientPaint) {
        Color[] colorArray = radialGradientPaint.getColors();
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = PaintAlpha.darker(colorArray[i]);
        }
        return new RadialGradientPaint(radialGradientPaint.getCenterPoint(), radialGradientPaint.getRadius(), radialGradientPaint.getFocusPoint(), radialGradientPaint.getFractions(), colorArray, radialGradientPaint.getCycleMethod(), radialGradientPaint.getColorSpace(), radialGradientPaint.getTransform());
    }

    private static TexturePaint darkerTexturePaint(TexturePaint texturePaint) {
        if (texturePaint.getImage().getColorModel().isAlphaPremultiplied()) {
            // empty if block
        }
        BufferedImage bufferedImage = PaintAlpha.cloneImage(texturePaint.getImage());
        WritableRaster writableRaster = bufferedImage.copyData(null);
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getMinY() + writableRaster.getHeight();
        int n4 = writableRaster.getWidth();
        int[] nArray = new int[n4 * bufferedImage.getSampleModel().getNumBands()];
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            int[] nArray2 = new int[4];
            for (int i = n2; i < n3; ++i) {
                nArray = writableRaster.getPixels(n, i, n4, 1, nArray);
                for (int j = 0; j < nArray.length; ++j) {
                    nArray2 = bufferedImage.getColorModel().getComponents(nArray[j], nArray2, 0);
                    nArray2[0] = (int)((double)nArray2[0] * 0.7);
                    nArray2[1] = (int)((double)nArray2[1] * 0.7);
                    nArray2[2] = (int)((double)nArray2[2] * 0.7);
                    nArray[j] = bufferedImage.getColorModel().getDataElement(nArray2, 0);
                }
                writableRaster.setPixels(n, i, n4, 1, nArray);
            }
            bufferedImage.setData(writableRaster);
            return new TexturePaint(bufferedImage, texturePaint.getAnchorRect());
        }
        if (bufferedImage.getSampleModel().getNumBands() == 4) {
            for (int i = n2; i < n3; ++i) {
                nArray = writableRaster.getPixels(n, i, n4, 1, nArray);
                for (int j = 0; j < nArray.length; ++j) {
                    nArray[j] = (int)((double)nArray[j++] * 0.7);
                    nArray[j] = (int)((double)nArray[j++] * 0.7);
                    nArray[j] = (int)((double)nArray[j++] * 0.7);
                }
                writableRaster.setPixels(n, i, n4, 1, nArray);
            }
            bufferedImage.setData(writableRaster);
            return new TexturePaint(bufferedImage, texturePaint.getAnchorRect());
        }
        for (int i = n2; i < n3; ++i) {
            nArray = writableRaster.getPixels(n, i, n4, 1, nArray);
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = (int)((double)nArray[j] * 0.7);
            }
            writableRaster.setPixels(n, i, n4, 1, nArray);
        }
        bufferedImage.setData(writableRaster);
        return new TexturePaint(bufferedImage, texturePaint.getAnchorRect());
    }

    public static BufferedImage cloneImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster();
        writableRaster2.setRect(writableRaster);
        Hashtable<String, Object> hashtable = null;
        String[] stringArray = bufferedImage.getPropertyNames();
        if (stringArray != null) {
            hashtable = new Hashtable<String, Object>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], bufferedImage.getProperty(stringArray[i]));
            }
        }
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster2, bufferedImage.isAlphaPremultiplied(), hashtable);
    }
}

