/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.PaintMap;
import ai.org.jfree.chart.StrokeMap;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.entity.PieSectionEntity;
import ai.org.jfree.chart.labels.PieSectionLabelGenerator;
import ai.org.jfree.chart.labels.PieToolTipGenerator;
import ai.org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import ai.org.jfree.chart.plot.AbstractPieLabelDistributor;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.PieLabelDistributor;
import ai.org.jfree.chart.plot.PieLabelLinkStyle;
import ai.org.jfree.chart.plot.PieLabelRecord;
import ai.org.jfree.chart.plot.PiePlot;
import ai.org.jfree.chart.plot.PiePlotState;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.urls.PieURLGenerator;
import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.chart.util.ShadowGenerator;
import ai.org.jfree.data.DefaultKeyedValues;
import ai.org.jfree.data.KeyedValues;
import ai.org.jfree.data.general.Dataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetChangeListener;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.G2TextMeasurer;
import ai.org.jfree.text.TextBlock;
import ai.org.jfree.text.TextBox;
import ai.org.jfree.text.TextMeasurer;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.Rotation;
import ai.org.jfree.util.ShapeUtilities;
import ai.org.jfree.util.UnitType;
import com.activeintra.aichart.PieGradientPaintTransformer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class CustomPiePlot
extends PiePlot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -795612466005590431L;
    public static final double DEFAULT_INTERIOR_GAP = 0.08;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = new Color(151, 151, 151, 128);
    public static final double DEFAULT_MINIMUM_ARC_ANGLE_TO_DRAW = 1.0E-5;
    private PieDataset dataset;
    private int pieIndex;
    private double interiorGap;
    private boolean circular;
    private double startAngle;
    private Rotation direction;
    private PaintMap sectionPaintMap;
    private transient Paint baseSectionPaint;
    private boolean autoPopulateSectionPaint;
    private boolean sectionOutlinesVisible;
    private PaintMap sectionOutlinePaintMap;
    private transient Paint baseSectionOutlinePaint;
    private boolean autoPopulateSectionOutlinePaint;
    private StrokeMap sectionOutlineStrokeMap;
    private transient Stroke baseSectionOutlineStroke;
    private boolean autoPopulateSectionOutlineStroke;
    private transient Paint shadowPaint = Color.gray;
    private double shadowXOffset = 4.0;
    private double shadowYOffset = 4.0;
    private Map explodePercentages;
    private PieSectionLabelGenerator labelGenerator;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private transient Paint labelOutlinePaint;
    private transient Stroke labelOutlineStroke;
    private transient Paint labelShadowPaint;
    private boolean simpleLabels = true;
    private RectangleInsets labelPadding;
    private RectangleInsets simpleLabelOffset;
    private double maximumLabelWidth = 0.14;
    private double labelGap = 0.025;
    private boolean labelLinksVisible;
    private PieLabelLinkStyle labelLinkStyle = PieLabelLinkStyle.STANDARD;
    private double labelLinkMargin = 0.025;
    private transient Paint labelLinkPaint = Color.black;
    private transient Stroke labelLinkStroke = new BasicStroke(0.5f);
    private AbstractPieLabelDistributor labelDistributor;
    private PieToolTipGenerator toolTipGenerator;
    private PieURLGenerator urlGenerator;
    private PieSectionLabelGenerator legendLabelGenerator;
    private PieSectionLabelGenerator legendLabelToolTipGenerator;
    private PieURLGenerator legendLabelURLGenerator;
    private boolean ignoreNullValues;
    private boolean ignoreZeroValues;
    private transient Shape legendItemShape;
    private double minimumArcAngleToDraw;
    private ShadowGenerator shadowGenerator;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle((String)"ai.org.jfree.chart.plot.LocalizationBundle");
    static final boolean DEBUG_DRAW_INTERIOR = false;
    static final boolean DEBUG_DRAW_LINK_AREA = false;
    static final boolean DEBUG_DRAW_PIE_AREA = false;
    private GradientPaintTransformer gradientPaintTransformer;
    private transient Paint sectionPaint;
    private transient Paint sectionOutlinePaint;
    private transient Stroke sectionOutlineStroke;

    public CustomPiePlot() {
        this(null);
    }

    public CustomPiePlot(PieDataset pieDataset) {
        this.dataset = pieDataset;
        if (pieDataset != null) {
            pieDataset.addChangeListener((DatasetChangeListener)this);
        }
        this.pieIndex = 0;
        this.interiorGap = 0.08;
        this.circular = true;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.minimumArcAngleToDraw = 1.0E-5;
        this.sectionPaint = null;
        this.sectionPaintMap = new PaintMap();
        this.baseSectionPaint = Color.gray;
        this.autoPopulateSectionPaint = true;
        this.sectionOutlinesVisible = true;
        this.sectionOutlinePaint = null;
        this.sectionOutlinePaintMap = new PaintMap();
        this.baseSectionOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.autoPopulateSectionOutlinePaint = false;
        this.sectionOutlineStroke = null;
        this.sectionOutlineStrokeMap = new StrokeMap();
        this.baseSectionOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.autoPopulateSectionOutlineStroke = false;
        this.explodePercentages = new TreeMap();
        this.labelGenerator = new StandardPieSectionLabelGenerator();
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelBackgroundPaint = DEFAULT_LABEL_BACKGROUND_PAINT;
        this.labelOutlinePaint = DEFAULT_LABEL_OUTLINE_PAINT;
        this.labelOutlineStroke = DEFAULT_LABEL_OUTLINE_STROKE;
        this.labelShadowPaint = DEFAULT_LABEL_SHADOW_PAINT;
        this.labelLinksVisible = true;
        this.labelDistributor = new PieLabelDistributor(0);
        this.simpleLabels = false;
        this.simpleLabelOffset = new RectangleInsets(UnitType.RELATIVE, 0.18, 0.18, 0.18, 0.18);
        this.labelPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        this.toolTipGenerator = null;
        this.urlGenerator = null;
        this.legendLabelGenerator = new StandardPieSectionLabelGenerator();
        this.legendLabelToolTipGenerator = null;
        this.legendLabelURLGenerator = null;
        this.legendItemShape = Plot.DEFAULT_LEGEND_ITEM_CIRCLE;
        this.ignoreNullValues = false;
        this.ignoreZeroValues = false;
        this.shadowGenerator = null;
        this.gradientPaintTransformer = new PieGradientPaintTransformer();
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset pieDataset) {
        PieDataset pieDataset2 = this.dataset;
        if (pieDataset2 != null) {
            pieDataset2.removeChangeListener((DatasetChangeListener)this);
        }
        this.dataset = pieDataset;
        if (pieDataset != null) {
            this.setDatasetGroup(pieDataset.getGroup());
            pieDataset.addChangeListener((DatasetChangeListener)this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)pieDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int n) {
        this.pieIndex = n;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.fireChangeEvent();
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = rotation;
        this.fireChangeEvent();
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("Invalid 'percent' (" + d + ") argument.");
        }
        if (this.interiorGap != d) {
            this.interiorGap = d;
            this.fireChangeEvent();
        }
    }

    public boolean isCircular() {
        return this.circular;
    }

    public void setCircular(boolean bl) {
        this.setCircular(bl, true);
    }

    public void setCircular(boolean bl, boolean bl2) {
        this.circular = bl;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean getIgnoreNullValues() {
        return this.ignoreNullValues;
    }

    public void setIgnoreNullValues(boolean bl) {
        this.ignoreNullValues = bl;
        this.fireChangeEvent();
    }

    public boolean getIgnoreZeroValues() {
        return this.ignoreZeroValues;
    }

    public void setIgnoreZeroValues(boolean bl) {
        this.ignoreZeroValues = bl;
        this.fireChangeEvent();
    }

    protected Paint lookupSectionPaint(Comparable comparable) {
        return this.lookupSectionPaint(comparable, this.getAutoPopulateSectionPaint());
    }

    protected Paint lookupSectionPaint(Comparable comparable, boolean bl) {
        Paint paint = this.getSectionPaint();
        if (paint != null) {
            return paint;
        }
        paint = this.sectionPaintMap.getPaint(comparable);
        if (paint != null) {
            return paint;
        }
        if (bl) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextPaint();
                this.sectionPaintMap.put(comparable, paint);
            } else {
                paint = this.baseSectionPaint;
            }
        } else {
            paint = this.baseSectionPaint;
        }
        return paint;
    }

    public Paint getSectionPaint() {
        return this.sectionPaint;
    }

    public void setSectionPaint(Paint paint) {
        this.sectionPaint = paint;
        this.fireChangeEvent();
    }

    protected Comparable getSectionKey(int n) {
        Comparable<Integer> comparable = null;
        if (this.dataset != null && n >= 0 && n < this.dataset.getItemCount()) {
            comparable = this.dataset.getKey(n);
        }
        if (comparable == null) {
            comparable = new Integer(n);
        }
        return comparable;
    }

    public Paint getSectionPaint(Comparable comparable) {
        return this.sectionPaintMap.getPaint(comparable);
    }

    public void setSectionPaint(Comparable comparable, Paint paint) {
        this.sectionPaintMap.put(comparable, paint);
        this.fireChangeEvent();
    }

    public void clearSectionPaints(boolean bl) {
        this.sectionPaintMap.clear();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseSectionPaint() {
        return this.baseSectionPaint;
    }

    public void setBaseSectionPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getAutoPopulateSectionPaint() {
        return this.autoPopulateSectionPaint;
    }

    public void setAutoPopulateSectionPaint(boolean bl) {
        this.autoPopulateSectionPaint = bl;
        this.fireChangeEvent();
    }

    public boolean getSectionOutlinesVisible() {
        return this.sectionOutlinesVisible;
    }

    public void setSectionOutlinesVisible(boolean bl) {
        this.sectionOutlinesVisible = bl;
        this.fireChangeEvent();
    }

    protected Paint lookupSectionOutlinePaint(Comparable comparable) {
        return this.lookupSectionOutlinePaint(comparable, this.getAutoPopulateSectionOutlinePaint());
    }

    protected Paint lookupSectionOutlinePaint(Comparable comparable, boolean bl) {
        Paint paint = this.getSectionOutlinePaint();
        if (paint != null) {
            return paint;
        }
        paint = this.sectionOutlinePaintMap.getPaint(comparable);
        if (paint != null) {
            return paint;
        }
        if (bl) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                paint = drawingSupplier.getNextOutlinePaint();
                this.sectionOutlinePaintMap.put(comparable, paint);
            } else {
                paint = this.baseSectionOutlinePaint;
            }
        } else {
            paint = this.baseSectionOutlinePaint;
        }
        return paint;
    }

    public Paint getSectionOutlinePaint(Comparable comparable) {
        return this.sectionOutlinePaintMap.getPaint(comparable);
    }

    public void setSectionOutlinePaint(Comparable comparable, Paint paint) {
        this.sectionOutlinePaintMap.put(comparable, paint);
        this.fireChangeEvent();
    }

    public void clearSectionOutlinePaints(boolean bl) {
        this.sectionOutlinePaintMap.clear();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Paint getBaseSectionOutlinePaint() {
        return this.baseSectionOutlinePaint;
    }

    public void setBaseSectionOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSectionOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean getAutoPopulateSectionOutlinePaint() {
        return this.autoPopulateSectionOutlinePaint;
    }

    public void setAutoPopulateSectionOutlinePaint(boolean bl) {
        this.autoPopulateSectionOutlinePaint = bl;
        this.fireChangeEvent();
    }

    protected Stroke lookupSectionOutlineStroke(Comparable comparable) {
        return this.lookupSectionOutlineStroke(comparable, this.getAutoPopulateSectionOutlineStroke());
    }

    protected Stroke lookupSectionOutlineStroke(Comparable comparable, boolean bl) {
        Stroke stroke = this.getSectionOutlineStroke();
        if (stroke != null) {
            return stroke;
        }
        stroke = this.sectionOutlineStrokeMap.getStroke(comparable);
        if (stroke != null) {
            return stroke;
        }
        if (bl) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                stroke = drawingSupplier.getNextOutlineStroke();
                this.sectionOutlineStrokeMap.put(comparable, stroke);
            } else {
                stroke = this.baseSectionOutlineStroke;
            }
        } else {
            stroke = this.baseSectionOutlineStroke;
        }
        return stroke;
    }

    public Stroke getSectionOutlineStroke(Comparable comparable) {
        return this.sectionOutlineStrokeMap.getStroke(comparable);
    }

    public void setSectionOutlineStroke(Comparable comparable, Stroke stroke) {
        this.sectionOutlineStrokeMap.put(comparable, stroke);
        this.fireChangeEvent();
    }

    public void clearSectionOutlineStrokes(boolean bl) {
        this.sectionOutlineStrokeMap.clear();
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public Stroke getBaseSectionOutlineStroke() {
        return this.baseSectionOutlineStroke;
    }

    public void setBaseSectionOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSectionOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public boolean getAutoPopulateSectionOutlineStroke() {
        return this.autoPopulateSectionOutlineStroke;
    }

    public void setAutoPopulateSectionOutlineStroke(boolean bl) {
        this.autoPopulateSectionOutlineStroke = bl;
        this.fireChangeEvent();
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        this.shadowPaint = paint;
        this.fireChangeEvent();
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double d) {
        this.shadowXOffset = d;
        this.fireChangeEvent();
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double d) {
        this.shadowYOffset = d;
        this.fireChangeEvent();
    }

    public double getExplodePercent(Comparable comparable) {
        Number number;
        double d = 0.0;
        if (this.explodePercentages != null && (number = (Number)this.explodePercentages.get(comparable)) != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public void setExplodePercent(Comparable comparable, double d) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (this.explodePercentages == null) {
            this.explodePercentages = new TreeMap();
        }
        this.explodePercentages.put(comparable, new Double(d));
        this.fireChangeEvent();
    }

    public double getMaximumExplodePercent() {
        if (this.dataset == null) {
            return 0.0;
        }
        double d = 0.0;
        for (Comparable comparable : this.dataset.getKeys()) {
            Number number = (Number)this.explodePercentages.get(comparable);
            if (number == null) continue;
            d = Math.max(d, number.doubleValue());
        }
        return d;
    }

    public PieSectionLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.labelGenerator = pieSectionLabelGenerator;
        this.fireChangeEvent();
    }

    public double getLabelGap() {
        return this.labelGap;
    }

    public void setLabelGap(double d) {
        this.labelGap = d;
        this.fireChangeEvent();
    }

    public double getMaximumLabelWidth() {
        return this.maximumLabelWidth;
    }

    public void setMaximumLabelWidth(double d) {
        this.maximumLabelWidth = d;
        this.fireChangeEvent();
    }

    public boolean getLabelLinksVisible() {
        return this.labelLinksVisible;
    }

    public void setLabelLinksVisible(boolean bl) {
        this.labelLinksVisible = bl;
        this.fireChangeEvent();
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle pieLabelLinkStyle) {
        if (pieLabelLinkStyle == null) {
            throw new IllegalArgumentException("Null 'style' argument.");
        }
        this.labelLinkStyle = pieLabelLinkStyle;
        this.fireChangeEvent();
    }

    public double getLabelLinkMargin() {
        return this.labelLinkMargin;
    }

    public void setLabelLinkMargin(double d) {
        this.labelLinkMargin = d;
        this.fireChangeEvent();
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getLabelLinkStroke() {
        return this.labelLinkStroke;
    }

    public void setLabelLinkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.labelLinkStroke = stroke;
        this.fireChangeEvent();
    }

    protected double getLabelLinkDepth() {
        return 0.1;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.fireChangeEvent();
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        this.labelBackgroundPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        this.labelOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Stroke stroke) {
        this.labelOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getLabelShadowPaint() {
        return this.labelShadowPaint;
    }

    public void setLabelShadowPaint(Paint paint) {
        this.labelShadowPaint = paint;
        this.fireChangeEvent();
    }

    public RectangleInsets getLabelPadding() {
        return this.labelPadding;
    }

    public void setLabelPadding(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.labelPadding = rectangleInsets;
        this.fireChangeEvent();
    }

    public boolean getSimpleLabels() {
        return this.simpleLabels;
    }

    public void setSimpleLabels(boolean bl) {
        this.simpleLabels = bl;
        this.fireChangeEvent();
    }

    public RectangleInsets getSimpleLabelOffset() {
        return this.simpleLabelOffset;
    }

    public void setSimpleLabelOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.simpleLabelOffset = rectangleInsets;
        this.fireChangeEvent();
    }

    public AbstractPieLabelDistributor getLabelDistributor() {
        return this.labelDistributor;
    }

    public void setLabelDistributor(AbstractPieLabelDistributor abstractPieLabelDistributor) {
        if (abstractPieLabelDistributor == null) {
            throw new IllegalArgumentException("Null 'distributor' argument.");
        }
        this.labelDistributor = abstractPieLabelDistributor;
        this.fireChangeEvent();
    }

    public PieToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieToolTipGenerator pieToolTipGenerator) {
        this.toolTipGenerator = pieToolTipGenerator;
        this.fireChangeEvent();
    }

    public PieURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(PieURLGenerator pieURLGenerator) {
        this.urlGenerator = pieURLGenerator;
        this.fireChangeEvent();
    }

    public double getMinimumArcAngleToDraw() {
        return this.minimumArcAngleToDraw;
    }

    public void setMinimumArcAngleToDraw(double d) {
        this.minimumArcAngleToDraw = d;
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.fireChangeEvent();
    }

    public PieSectionLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        if (pieSectionLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendLabelGenerator = pieSectionLabelGenerator;
        this.fireChangeEvent();
    }

    public PieSectionLabelGenerator getLegendLabelToolTipGenerator() {
        return this.legendLabelToolTipGenerator;
    }

    public void setLegendLabelToolTipGenerator(PieSectionLabelGenerator pieSectionLabelGenerator) {
        this.legendLabelToolTipGenerator = pieSectionLabelGenerator;
        this.fireChangeEvent();
    }

    public PieURLGenerator getLegendLabelURLGenerator() {
        return this.legendLabelURLGenerator;
    }

    public void setLegendLabelURLGenerator(PieURLGenerator pieURLGenerator) {
        this.legendLabelURLGenerator = pieURLGenerator;
        this.fireChangeEvent();
    }

    public ShadowGenerator getShadowGenerator() {
        return this.shadowGenerator;
    }

    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.shadowGenerator = shadowGenerator;
        this.fireChangeEvent();
    }

    public void handleMouseWheelRotation(int n) {
        this.setStartAngle(this.startAngle + (double)n * 4.0);
    }

    public PiePlotState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CustomPiePlot customPiePlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = new PiePlotState(plotRenderingInfo);
        piePlotState.setPassesRequired(2);
        if (this.dataset != null) {
            piePlotState.setTotal(DatasetUtilities.calculatePieDatasetTotal((PieDataset)customPiePlot.getDataset()));
        }
        piePlotState.setLatestAngle(customPiePlot.getStartAngle());
        return piePlotState;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull((PieDataset)this.dataset)) {
            Graphics2D graphics2D2 = graphics2D;
            BufferedImage bufferedImage = null;
            if (this.shadowGenerator != null) {
                bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
                graphics2D = bufferedImage.createGraphics();
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
            }
            this.drawPie(graphics2D, rectangle2D, plotRenderingInfo);
            if (this.shadowGenerator != null) {
                BufferedImage bufferedImage2 = this.shadowGenerator.createDropShadow(bufferedImage);
                graphics2D = graphics2D2;
                graphics2D.drawImage((Image)bufferedImage2, (int)rectangle2D.getX() + this.shadowGenerator.calculateOffsetX(), (int)rectangle2D.getY() + this.shadowGenerator.calculateOffsetY(), null);
                graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), null);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    protected void drawPie(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        double d = 0.0;
        if (this.labelGenerator != null && !this.simpleLabels) {
            d = this.labelGap + this.maximumLabelWidth;
        }
        double d2 = rectangle2D.getWidth() * (this.interiorGap + d) * 2.0;
        double d3 = rectangle2D.getHeight() * this.interiorGap * 2.0;
        double d4 = rectangle2D.getX() + d2 / 2.0;
        double d5 = rectangle2D.getY() + d3 / 2.0;
        double d6 = rectangle2D.getWidth() - d2;
        double d7 = rectangle2D.getHeight() - d3;
        if (this.circular) {
            double d8 = Math.min(d6, d7) / 2.0;
            d4 = (d4 + d4 + d6) / 2.0 - d8;
            d5 = (d5 + d5 + d7) / 2.0 - d8;
            d6 = 2.0 * d8;
            d7 = 2.0 * d8;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d6, d7);
        piePlotState.setLinkArea((Rectangle2D)double_);
        double d9 = 0.0;
        if (!this.simpleLabels) {
            d9 = this.labelLinkMargin;
        }
        double d10 = ((RectangularShape)double_).getWidth() * d9 * 2.0;
        double d11 = ((RectangularShape)double_).getHeight() * d9 * 2.0;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 + d10 / 2.0, d5 + d11 / 2.0, d6 - d10, d7 - d11);
        piePlotState.setExplodedPieArea((Rectangle2D)double_2);
        double d12 = this.getMaximumExplodePercent();
        double d13 = d12 / (1.0 + d12);
        double d14 = ((RectangularShape)double_2).getWidth() * d13;
        double d15 = ((RectangularShape)double_2).getHeight() * d13;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(((RectangularShape)double_2).getX() + d14 / 2.0, ((RectangularShape)double_2).getY() + d15 / 2.0, ((RectangularShape)double_2).getWidth() - d14, ((RectangularShape)double_2).getHeight() - d15);
        piePlotState.setPieArea((Rectangle2D)double_3);
        piePlotState.setPieCenterX(double_3.getCenterX());
        piePlotState.setPieCenterY(double_3.getCenterY());
        piePlotState.setPieWRadius(((RectangularShape)double_3).getWidth() / 2.0);
        piePlotState.setPieHRadius(((RectangularShape)double_3).getHeight() / 2.0);
        if (this.dataset != null && this.dataset.getKeys().size() > 0) {
            List list = this.dataset.getKeys();
            double d16 = DatasetUtilities.calculatePieDatasetTotal((PieDataset)this.dataset);
            int n = piePlotState.getPassesRequired();
            for (int i = 0; i < n; ++i) {
                double d17 = 0.0;
                for (int j = 0; j < list.size(); ++j) {
                    double d18;
                    Number number = this.dataset.getValue(j);
                    if (number == null || !((d18 = number.doubleValue()) > 0.0)) continue;
                    d17 += d18;
                    this.drawItem(graphics2D, j, double_2, piePlotState, i);
                }
            }
            if (this.simpleLabels) {
                this.drawSimpleLabels(graphics2D, list, d16, rectangle2D, double_, piePlotState);
            } else {
                this.drawLabels(graphics2D, list, d16, rectangle2D, double_, piePlotState);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    protected void drawItem(Graphics2D graphics2D, int n, Rectangle2D rectangle2D, PiePlotState piePlotState, int n2) {
        Number number = this.dataset.getValue(n);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.direction == Rotation.CLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 - d / piePlotState.getTotal() * 360.0;
        } else if (this.direction == Rotation.ANTICLOCKWISE) {
            d2 = piePlotState.getLatestAngle();
            d3 = d2 + d / piePlotState.getTotal() * 360.0;
        } else {
            throw new IllegalStateException("Rotation type not recognised.");
        }
        double d4 = d3 - d2;
        if (Math.abs(d4) > this.getMinimumArcAngleToDraw()) {
            double d5 = 0.0;
            double d6 = this.getMaximumExplodePercent();
            if (d6 > 0.0) {
                d5 = this.getExplodePercent(n) / d6;
            }
            Rectangle2D rectangle2D2 = this.getArcBounds(piePlotState.getPieArea(), piePlotState.getExplodedPieArea(), d2, d4, d5);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, d4, 2);
            if (n2 == 0) {
                if (this.shadowPaint != null && this.shadowGenerator == null) {
                    Shape shape = ShapeUtilities.createTranslatedShape((Shape)double_, (double)((float)this.shadowXOffset), (double)((float)this.shadowYOffset));
                    graphics2D.setPaint(this.shadowPaint);
                    graphics2D.fill(shape);
                }
            } else if (n2 == 1) {
                EntityCollection entityCollection;
                Paint paint;
                Comparable comparable = this.getSectionKey(n);
                Paint paint2 = this.lookupSectionPaint(comparable, piePlotState);
                if (this.getGradientPaintTransformer() != null && paint2 instanceof GradientPaint) {
                    paint = (GradientPaint)paint2;
                    paint2 = this.getGradientPaintTransformer().transform(paint, (Shape)double_);
                }
                graphics2D.setPaint(paint2);
                graphics2D.fill(double_);
                paint = this.lookupSectionOutlinePaint(comparable);
                Stroke stroke = this.lookupSectionOutlineStroke(comparable);
                if (this.sectionOutlinesVisible) {
                    graphics2D.setPaint(paint);
                    graphics2D.setStroke(stroke);
                    graphics2D.draw(double_);
                }
                if (piePlotState.getInfo() != null && (entityCollection = piePlotState.getEntityCollection()) != null) {
                    String string = null;
                    if (this.toolTipGenerator != null) {
                        string = this.toolTipGenerator.generateToolTip(this.dataset, comparable);
                    }
                    String string2 = null;
                    if (this.urlGenerator != null) {
                        string2 = this.urlGenerator.generateURL(this.dataset, comparable, this.pieIndex);
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity((Shape)double_, this.dataset, this.pieIndex, n, comparable, string, string2);
                    entityCollection.add((ChartEntity)pieSectionEntity);
                }
            }
        }
        piePlotState.setLatestAngle(d3);
    }

    protected void drawSimpleLabels(Graphics2D graphics2D, List list, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PiePlotState piePlotState) {
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Rectangle2D rectangle2D3 = this.simpleLabelOffset.createInsetRectangle(rectangle2D2);
        double d2 = 0.0;
        for (Comparable comparable : list) {
            String string;
            boolean bl = true;
            double d3 = 0.0;
            Number number = this.getDataset().getValue(comparable);
            if (number == null) {
                bl = !this.getIgnoreNullValues();
            } else {
                d3 = number.doubleValue();
                boolean bl2 = this.getIgnoreZeroValues() ? d3 > 0.0 : (bl = d3 >= 0.0);
            }
            if (!bl) continue;
            double d4 = this.getStartAngle() + this.getDirection().getFactor() * (((d2 += d3) - d3 / 2.0) * 360.0) / d;
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, this.getStartAngle(), d4 - this.getStartAngle(), 0);
            int n = (int)double_.getEndPoint().getX();
            int n2 = (int)double_.getEndPoint().getY();
            PieSectionLabelGenerator pieSectionLabelGenerator = this.getLabelGenerator();
            if (pieSectionLabelGenerator == null || (string = pieSectionLabelGenerator.generateSectionLabel(this.dataset, comparable)) == null) continue;
            graphics2D.setFont(this.labelFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D4 = TextUtilities.getTextBounds((String)string, (Graphics2D)graphics2D, (FontMetrics)fontMetrics);
            Rectangle2D rectangle2D5 = this.labelPadding.createOutsetRectangle(rectangle2D4);
            Shape shape = ShapeUtilities.createTranslatedShape((Shape)rectangle2D5, (double)((double)n - rectangle2D4.getCenterX()), (double)((double)n2 - rectangle2D4.getCenterY()));
            if (this.labelShadowPaint != null && this.shadowGenerator == null) {
                Shape shape2 = ShapeUtilities.createTranslatedShape((Shape)shape, (double)this.shadowXOffset, (double)this.shadowYOffset);
                graphics2D.setPaint(this.labelShadowPaint);
                graphics2D.fill(shape2);
            }
            if (this.labelBackgroundPaint != null) {
                graphics2D.setPaint(this.labelBackgroundPaint);
                graphics2D.fill(shape);
            }
            if (this.labelOutlinePaint != null && this.labelOutlineStroke != null) {
                graphics2D.setPaint(this.labelOutlinePaint);
                graphics2D.setStroke(this.labelOutlineStroke);
                graphics2D.draw(shape);
            }
            graphics2D.setPaint(this.labelPaint);
            graphics2D.setFont(this.labelFont);
            TextUtilities.drawAlignedString((String)this.getLabelGenerator().generateSectionLabel(this.getDataset(), comparable), (Graphics2D)graphics2D, (float)n, (float)n2, (TextAnchor)TextAnchor.CENTER);
        }
        graphics2D.setComposite(composite);
    }

    protected void drawLabels(Graphics2D graphics2D, List list, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PiePlotState piePlotState) {
        double d2;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        double d3 = 0.0;
        for (Comparable comparable : list) {
            boolean bl = true;
            d2 = 0.0;
            Number number = this.dataset.getValue(comparable);
            if (number == null) {
                bl = !this.ignoreNullValues;
            } else {
                d2 = number.doubleValue();
                boolean bl2 = this.ignoreZeroValues ? d2 > 0.0 : (bl = d2 >= 0.0);
            }
            if (!bl) continue;
            d3 += d2;
            double d4 = this.startAngle + this.direction.getFactor() * ((d3 - d2 / 2.0) * 360.0) / d;
            if (Math.cos(Math.toRadians(d4)) < 0.0) {
                defaultKeyedValues.addValue(comparable, (Number)new Double(d4));
                continue;
            }
            defaultKeyedValues2.addValue(comparable, (Number)new Double(d4));
        }
        graphics2D.setFont(this.getLabelFont());
        double d5 = rectangle2D.getX() + this.interiorGap * rectangle2D.getWidth();
        d2 = rectangle2D.getWidth() * this.labelGap;
        double d6 = rectangle2D2.getX() - d2 - d5;
        float f = (float)this.labelPadding.trimWidth(d6);
        if (this.labelGenerator != null) {
            this.drawLeftLabels((KeyedValues)defaultKeyedValues, graphics2D, rectangle2D, rectangle2D2, f, piePlotState);
            this.drawRightLabels((KeyedValues)defaultKeyedValues2, graphics2D, rectangle2D, rectangle2D2, f, piePlotState);
        }
        graphics2D.setComposite(composite);
    }

    protected void drawLeftLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, PiePlotState piePlotState) {
        this.labelDistributor.clear();
        double d = rectangle2D.getWidth() * this.labelGap;
        double d2 = piePlotState.getLinkArea().getHeight() / 2.0;
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(i));
            if (string == null) continue;
            TextBlock textBlock = TextUtilities.createTextBlock((String)string, (Font)this.labelFont, (Paint)this.labelPaint, (float)f, (TextMeasurer)new G2TextMeasurer(graphics2D));
            TextBox textBox = new TextBox(textBlock);
            textBox.setBackgroundPaint(this.labelBackgroundPaint);
            textBox.setOutlinePaint(this.labelOutlinePaint);
            textBox.setOutlineStroke(this.labelOutlineStroke);
            if (this.shadowGenerator == null) {
                textBox.setShadowPaint(this.labelShadowPaint);
            } else {
                textBox.setShadowPaint(null);
            }
            textBox.setInteriorGap(this.labelPadding);
            double d3 = Math.toRadians(keyedValues.getValue(i).doubleValue());
            double d4 = piePlotState.getPieCenterY() - Math.sin(d3) * d2;
            double d5 = textBox.getHeight(graphics2D);
            this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(i), d3, d4, textBox, d5, d / 2.0 + d / 2.0 * -Math.cos(d3), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keyedValues.getKey(i))));
        }
        double d6 = rectangle2D.getHeight();
        double d7 = d6 * this.getInteriorGap();
        this.labelDistributor.distributeLabels(rectangle2D.getMinY() + d7, d6 - 2.0 * d7);
        for (int i = 0; i < this.labelDistributor.getItemCount(); ++i) {
            this.drawLeftLabel(graphics2D, piePlotState, this.labelDistributor.getPieLabelRecord(i));
        }
    }

    protected void drawRightLabels(KeyedValues keyedValues, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, float f, PiePlotState piePlotState) {
        this.labelDistributor.clear();
        double d = rectangle2D.getWidth() * this.labelGap;
        double d2 = piePlotState.getLinkArea().getHeight() / 2.0;
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            String string = this.labelGenerator.generateSectionLabel(this.dataset, keyedValues.getKey(i));
            if (string == null) continue;
            TextBlock textBlock = TextUtilities.createTextBlock((String)string, (Font)this.labelFont, (Paint)this.labelPaint, (float)f, (TextMeasurer)new G2TextMeasurer(graphics2D));
            TextBox textBox = new TextBox(textBlock);
            textBox.setBackgroundPaint(this.labelBackgroundPaint);
            textBox.setOutlinePaint(this.labelOutlinePaint);
            textBox.setOutlineStroke(this.labelOutlineStroke);
            if (this.shadowGenerator == null) {
                textBox.setShadowPaint(this.labelShadowPaint);
            } else {
                textBox.setShadowPaint(null);
            }
            textBox.setInteriorGap(this.labelPadding);
            double d3 = Math.toRadians(keyedValues.getValue(i).doubleValue());
            double d4 = piePlotState.getPieCenterY() - Math.sin(d3) * d2;
            double d5 = textBox.getHeight(graphics2D);
            this.labelDistributor.addPieLabelRecord(new PieLabelRecord(keyedValues.getKey(i), d3, d4, textBox, d5, d / 2.0 + d / 2.0 * Math.cos(d3), 1.0 - this.getLabelLinkDepth() + this.getExplodePercent(keyedValues.getKey(i))));
        }
        double d6 = rectangle2D.getHeight();
        double d7 = d6 * this.getInteriorGap();
        this.labelDistributor.distributeLabels(rectangle2D.getMinY() + d7, d6 - 2.0 * d7);
        for (int i = 0; i < this.labelDistributor.getItemCount(); ++i) {
            this.drawRightLabel(graphics2D, piePlotState, this.labelDistributor.getPieLabelRecord(i));
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset == null) {
            return legendItemCollection;
        }
        List list = this.dataset.getKeys();
        int n = 0;
        Shape shape = this.getLegendItemShape();
        for (Comparable comparable : list) {
            Number number = this.dataset.getValue(comparable);
            boolean bl = true;
            if (number == null) {
                bl = !this.ignoreNullValues;
            } else {
                double d = number.doubleValue();
                if (d == 0.0) {
                    bl = !this.ignoreZeroValues;
                } else {
                    boolean bl2 = bl = d > 0.0;
                }
            }
            if (bl) {
                String string = this.legendLabelGenerator.generateSectionLabel(this.dataset, comparable);
                if (string != null) {
                    String string2 = string;
                    String string3 = null;
                    if (this.legendLabelToolTipGenerator != null) {
                        string3 = this.legendLabelToolTipGenerator.generateSectionLabel(this.dataset, comparable);
                    }
                    String string4 = null;
                    if (this.legendLabelURLGenerator != null) {
                        string4 = this.legendLabelURLGenerator.generateURL(this.dataset, comparable, this.pieIndex);
                    }
                    Paint paint = this.lookupSectionPaint(comparable);
                    Paint paint2 = this.lookupSectionOutlinePaint(comparable);
                    Stroke stroke = this.lookupSectionOutlineStroke(comparable);
                    LegendItem legendItem = new LegendItem(string, string2, string3, string4, true, shape, true, paint, true, paint2, stroke, false, (Shape)new Line2D.Float(), (Stroke)new BasicStroke(), (Paint)Color.black);
                    legendItem.setDataset((Dataset)this.getDataset());
                    legendItem.setSeriesIndex(this.dataset.getIndex(comparable));
                    legendItem.setSeriesKey(comparable);
                    legendItemCollection.add(legendItem);
                }
                ++n;
                continue;
            }
            ++n;
        }
        return legendItemCollection;
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_Plot");
    }

    protected Rectangle2D getArcBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2, double d3) {
        if (d3 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d, d2 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d, d2 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d4 = (point2D.getX() - point2D2.getX()) * d3;
        double d5 = (point2D.getY() - point2D2.getY()) * d3;
        return new Rectangle2D.Double(rectangle2D.getX() - d4, rectangle2D.getY() - d5, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected void drawLeftLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d = piePlotState.getLinkArea().getMinX();
        double d2 = d - pieLabelRecord.getGap();
        double d3 = pieLabelRecord.getAllocatedY();
        if (this.labelLinksVisible) {
            double d4;
            double d5 = pieLabelRecord.getAngle();
            double d6 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
            double d7 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
            double d8 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getLinkArea().getWidth() / 2.0;
            double d9 = d4 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getLinkArea().getHeight() / 2.0;
            graphics2D.setPaint(this.labelLinkPaint);
            graphics2D.setStroke(this.labelLinkStroke);
            PieLabelLinkStyle pieLabelLinkStyle = this.getLabelLinkStyle();
            if (pieLabelLinkStyle.equals((Object)PieLabelLinkStyle.STANDARD)) {
                graphics2D.draw(new Line2D.Double(d6, d7, d8, d4));
                graphics2D.draw(new Line2D.Double(d, d9, d8, d4));
                graphics2D.draw(new Line2D.Double(d, d9, d2, d3));
            } else if (pieLabelLinkStyle.equals((Object)PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurve2D.Float float_ = new QuadCurve2D.Float();
                ((QuadCurve2D)float_).setCurve(d2, d3, d, d9, d8, d4);
                graphics2D.draw(float_);
                graphics2D.draw(new Line2D.Double(d8, d4, d6, d7));
            } else if (pieLabelLinkStyle.equals((Object)PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurve2D.Float float_ = new CubicCurve2D.Float();
                ((CubicCurve2D)float_).setCurve(d2, d3, d, d9, d8, d4, d6, d7);
                graphics2D.draw(float_);
            }
        }
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d2, (float)d3, RectangleAnchor.RIGHT);
    }

    protected void drawRightLabel(Graphics2D graphics2D, PiePlotState piePlotState, PieLabelRecord pieLabelRecord) {
        double d = piePlotState.getLinkArea().getMaxX();
        double d2 = d + pieLabelRecord.getGap();
        double d3 = pieLabelRecord.getAllocatedY();
        if (this.labelLinksVisible) {
            double d4;
            double d5 = pieLabelRecord.getAngle();
            double d6 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getPieWRadius() * pieLabelRecord.getLinkPercent();
            double d7 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getPieHRadius() * pieLabelRecord.getLinkPercent();
            double d8 = piePlotState.getPieCenterX() + Math.cos(d5) * piePlotState.getLinkArea().getWidth() / 2.0;
            double d9 = d4 = piePlotState.getPieCenterY() - Math.sin(d5) * piePlotState.getLinkArea().getHeight() / 2.0;
            graphics2D.setPaint(this.labelLinkPaint);
            graphics2D.setStroke(this.labelLinkStroke);
            PieLabelLinkStyle pieLabelLinkStyle = this.getLabelLinkStyle();
            if (pieLabelLinkStyle.equals((Object)PieLabelLinkStyle.STANDARD)) {
                graphics2D.draw(new Line2D.Double(d6, d7, d8, d4));
                graphics2D.draw(new Line2D.Double(d, d9, d8, d4));
                graphics2D.draw(new Line2D.Double(d, d9, d2, d3));
            } else if (pieLabelLinkStyle.equals((Object)PieLabelLinkStyle.QUAD_CURVE)) {
                QuadCurve2D.Float float_ = new QuadCurve2D.Float();
                ((QuadCurve2D)float_).setCurve(d2, d3, d, d9, d8, d4);
                graphics2D.draw(float_);
                graphics2D.draw(new Line2D.Double(d8, d4, d6, d7));
            } else if (pieLabelLinkStyle.equals((Object)PieLabelLinkStyle.CUBIC_CURVE)) {
                CubicCurve2D.Float float_ = new CubicCurve2D.Float();
                ((CubicCurve2D)float_).setCurve(d2, d3, d, d9, d8, d4, d6, d7);
                graphics2D.draw(float_);
            }
        }
        TextBox textBox = pieLabelRecord.getLabel();
        textBox.draw(graphics2D, (float)d2, (float)d3, RectangleAnchor.LEFT);
    }

    protected Point2D getArcCenter(PiePlotState piePlotState, Comparable comparable) {
        Point2D.Double double_ = new Point2D.Double(piePlotState.getPieCenterX(), piePlotState.getPieCenterY());
        double d = this.getExplodePercent(comparable);
        double d2 = this.getMaximumExplodePercent();
        if (d2 > 0.0) {
            d /= d2;
        }
        if (d != 0.0) {
            double d3;
            double d4;
            Rectangle2D rectangle2D = piePlotState.getPieArea();
            Rectangle2D rectangle2D2 = piePlotState.getExplodedPieArea();
            Number number = this.dataset.getValue(comparable);
            double d5 = number.doubleValue();
            if (this.direction == Rotation.CLOCKWISE) {
                d4 = piePlotState.getLatestAngle();
                d3 = d4 - d5 / piePlotState.getTotal() * 360.0;
            } else if (this.direction == Rotation.ANTICLOCKWISE) {
                d4 = piePlotState.getLatestAngle();
                d3 = d4 + d5 / piePlotState.getTotal() * 360.0;
            } else {
                throw new IllegalStateException("Rotation type not recognised.");
            }
            double d6 = d3 - d4;
            Arc2D.Double double_2 = new Arc2D.Double(rectangle2D, d4, d6 / 2.0, 0);
            Point2D point2D = double_2.getEndPoint();
            Arc2D.Double double_3 = new Arc2D.Double(rectangle2D2, d4, d6 / 2.0, 0);
            Point2D point2D2 = double_3.getEndPoint();
            double d7 = (point2D.getX() - point2D2.getX()) * d;
            double d8 = (point2D.getY() - point2D2.getY()) * d;
            double_ = new Point2D.Double(piePlotState.getPieCenterX() - d7, piePlotState.getPieCenterY() - d8);
        }
        return double_;
    }

    protected Paint lookupSectionPaint(Comparable comparable, PiePlotState piePlotState) {
        Paint paint = this.lookupSectionPaint(comparable, this.getAutoPopulateSectionPaint());
        try {
            Class<?> clazz = Class.forName("java.awt.RadialGradientPaint");
            Constructor<?> constructor = clazz.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
            if (clazz.isInstance(paint)) {
                Method method = clazz.getMethod("getFractions", new Class[0]);
                Object object = method.invoke((Object)paint, new Object[0]);
                method = clazz.getMethod("getColors", new Class[0]);
                Object object2 = method.invoke((Object)paint, new Object[0]);
                Point2D point2D = this.getArcCenter(piePlotState, comparable);
                float f = new Float(piePlotState.getPieHRadius()).floatValue();
                Paint paint2 = (Paint)constructor.newInstance(point2D, new Float(f), object, object2);
                return paint2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PiePlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CustomPiePlot customPiePlot = (CustomPiePlot)object;
        if (this.pieIndex != customPiePlot.pieIndex) {
            return false;
        }
        if (this.interiorGap != customPiePlot.interiorGap) {
            return false;
        }
        if (this.circular != customPiePlot.circular) {
            return false;
        }
        if (this.startAngle != customPiePlot.startAngle) {
            return false;
        }
        if (this.direction != customPiePlot.direction) {
            return false;
        }
        if (this.ignoreZeroValues != customPiePlot.ignoreZeroValues) {
            return false;
        }
        if (this.ignoreNullValues != customPiePlot.ignoreNullValues) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.sectionPaint, (Paint)customPiePlot.sectionPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionPaintMap, (Object)customPiePlot.sectionPaintMap)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.baseSectionPaint, (Paint)customPiePlot.baseSectionPaint)) {
            return false;
        }
        if (this.sectionOutlinesVisible != customPiePlot.sectionOutlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.sectionOutlinePaint, (Paint)customPiePlot.sectionOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionOutlinePaintMap, (Object)customPiePlot.sectionOutlinePaintMap)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.baseSectionOutlinePaint, (Paint)customPiePlot.baseSectionOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionOutlineStroke, (Object)customPiePlot.sectionOutlineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.sectionOutlineStrokeMap, (Object)customPiePlot.sectionOutlineStrokeMap)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.baseSectionOutlineStroke, (Object)customPiePlot.baseSectionOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.shadowPaint, (Paint)customPiePlot.shadowPaint)) {
            return false;
        }
        if (this.shadowXOffset != customPiePlot.shadowXOffset) {
            return false;
        }
        if (this.shadowYOffset != customPiePlot.shadowYOffset) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.explodePercentages, (Object)customPiePlot.explodePercentages)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelGenerator, (Object)customPiePlot.labelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelFont, (Object)customPiePlot.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelPaint, (Paint)customPiePlot.labelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelBackgroundPaint, (Paint)customPiePlot.labelBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelOutlinePaint, (Paint)customPiePlot.labelOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelOutlineStroke, (Object)customPiePlot.labelOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelShadowPaint, (Paint)customPiePlot.labelShadowPaint)) {
            return false;
        }
        if (this.simpleLabels != customPiePlot.simpleLabels) {
            return false;
        }
        if (!this.simpleLabelOffset.equals((Object)customPiePlot.simpleLabelOffset)) {
            return false;
        }
        if (!this.labelPadding.equals((Object)customPiePlot.labelPadding)) {
            return false;
        }
        if (this.maximumLabelWidth != customPiePlot.maximumLabelWidth) {
            return false;
        }
        if (this.labelGap != customPiePlot.labelGap) {
            return false;
        }
        if (this.labelLinkMargin != customPiePlot.labelLinkMargin) {
            return false;
        }
        if (this.labelLinksVisible != customPiePlot.labelLinksVisible) {
            return false;
        }
        if (!this.labelLinkStyle.equals((Object)customPiePlot.labelLinkStyle)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelLinkPaint, (Paint)customPiePlot.labelLinkPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.labelLinkStroke, (Object)customPiePlot.labelLinkStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.toolTipGenerator, (Object)customPiePlot.toolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.urlGenerator, (Object)customPiePlot.urlGenerator)) {
            return false;
        }
        if (this.minimumArcAngleToDraw != customPiePlot.minimumArcAngleToDraw) {
            return false;
        }
        if (!ShapeUtilities.equal((Shape)this.legendItemShape, (Shape)customPiePlot.legendItemShape)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.legendLabelGenerator, (Object)customPiePlot.legendLabelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.legendLabelToolTipGenerator, (Object)customPiePlot.legendLabelToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.legendLabelURLGenerator, (Object)customPiePlot.legendLabelURLGenerator)) {
            return false;
        }
        if (this.autoPopulateSectionPaint != customPiePlot.autoPopulateSectionPaint) {
            return false;
        }
        if (this.autoPopulateSectionOutlinePaint != customPiePlot.autoPopulateSectionOutlinePaint) {
            return false;
        }
        if (this.autoPopulateSectionOutlineStroke != customPiePlot.autoPopulateSectionOutlineStroke) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.shadowGenerator, (Object)customPiePlot.shadowGenerator);
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPiePlot customPiePlot = (CustomPiePlot)super.clone();
        if (customPiePlot.dataset != null) {
            customPiePlot.dataset.addChangeListener((DatasetChangeListener)customPiePlot);
        }
        if (this.urlGenerator instanceof PublicCloneable) {
            customPiePlot.urlGenerator = (PieURLGenerator)ObjectUtilities.clone((Object)this.urlGenerator);
        }
        customPiePlot.legendItemShape = ShapeUtilities.clone((Shape)this.legendItemShape);
        if (this.legendLabelGenerator != null) {
            customPiePlot.legendLabelGenerator = (PieSectionLabelGenerator)ObjectUtilities.clone((Object)this.legendLabelGenerator);
        }
        if (this.legendLabelToolTipGenerator != null) {
            customPiePlot.legendLabelToolTipGenerator = (PieSectionLabelGenerator)ObjectUtilities.clone((Object)this.legendLabelToolTipGenerator);
        }
        if (this.legendLabelURLGenerator instanceof PublicCloneable) {
            customPiePlot.legendLabelURLGenerator = (PieURLGenerator)ObjectUtilities.clone((Object)this.legendLabelURLGenerator);
        }
        return customPiePlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.sectionPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseSectionPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.sectionOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baseSectionOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.sectionOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.baseSectionOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.shadowPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelBackgroundPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.labelOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelShadowPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelLinkPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.labelLinkStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.legendItemShape, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.sectionPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseSectionPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.sectionOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baseSectionOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.sectionOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.baseSectionOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.labelShadowPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelLinkPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelLinkStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.legendItemShape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
    }

    public Paint getSectionPaint(int n) {
        Comparable comparable = this.getSectionKey(n);
        return this.getSectionPaint(comparable);
    }

    public void setSectionPaint(int n, Paint paint) {
        Comparable comparable = this.getSectionKey(n);
        this.setSectionPaint(comparable, paint);
    }

    public Paint getSectionOutlinePaint() {
        return this.sectionOutlinePaint;
    }

    public void setSectionOutlinePaint(Paint paint) {
        this.sectionOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getSectionOutlinePaint(int n) {
        Comparable comparable = this.getSectionKey(n);
        return this.getSectionOutlinePaint(comparable);
    }

    public void setSectionOutlinePaint(int n, Paint paint) {
        Comparable comparable = this.getSectionKey(n);
        this.setSectionOutlinePaint(comparable, paint);
    }

    public Stroke getSectionOutlineStroke() {
        return this.sectionOutlineStroke;
    }

    public void setSectionOutlineStroke(Stroke stroke) {
        this.sectionOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Stroke getSectionOutlineStroke(int n) {
        Comparable comparable = this.getSectionKey(n);
        return this.getSectionOutlineStroke(comparable);
    }

    public void setSectionOutlineStroke(int n, Stroke stroke) {
        Comparable comparable = this.getSectionKey(n);
        this.setSectionOutlineStroke(comparable, stroke);
    }

    public double getExplodePercent(int n) {
        Comparable comparable = this.getSectionKey(n);
        return this.getExplodePercent(comparable);
    }

    public void setExplodePercent(int n, double d) {
        Comparable comparable = this.getSectionKey(n);
        this.setExplodePercent(comparable, d);
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }
}

