/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.web.jsp;

import com.captcha.botdetect.CodeStyle;
import com.captcha.botdetect.HelpLinkMode;
import com.captcha.botdetect.ImageFormat;
import com.captcha.botdetect.ImageSize;
import com.captcha.botdetect.ImageStyle;
import com.captcha.botdetect.SoundFormat;
import com.captcha.botdetect.SoundRegenerationMode;
import com.captcha.botdetect.SoundStyle;
import com.captcha.botdetect.web.servlet.Captcha;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class CaptchaTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String userInputID;
    private Integer codeLength;
    private CodeStyle codeStyle;
    private Integer codeTimeout;
    private String disallowedCodeSubstrings;
    private List<ImageStyle> imageStyle;
    private ImageFormat imageFormat;
    private Integer imageWidth;
    private Integer imageHeight;
    private String customLightColor;
    private String customDarkColor;
    private Boolean soundEnabled;
    private List<SoundStyle> soundStyle;
    private SoundFormat soundFormat;
    private SoundRegenerationMode soundRegenerationMode;
    private Integer soundStartDelay;
    private String locale;
    private Boolean helpLinkEnabled;
    private HelpLinkMode helpLinkMode;
    private Integer tabIndex;
    private String imageTooltip;
    private String soundTooltip;
    private String reloadTooltip;
    private String helpLinkText;
    private String helpLinkUrl;
    private Boolean reloadEnabled;
    private Boolean useSmallIcons;
    private Boolean useHorizontalIcons;
    private String soundIconUrl;
    private String reloadIconUrl;
    private Integer iconsDivWidth;
    private String additionalCssClasses;
    private String additionalInlineCss;
    private Boolean addCssInclude;
    private Boolean addScriptInclude;
    private Boolean addInitScript;
    private Boolean autoFocusInput;
    private Boolean autoClearInput;
    private Boolean autoUppercaseInput;
    private Boolean autoReloadExpiredCaptchas;
    private Integer autoReloadTimeout;
    private Boolean remoteScriptEnabled;

    public int doEndTag() throws JspException {
        Captcha captcha = Captcha.load((ServletRequest)this.pageContext.getRequest(), (String)this.id);
        this.setAttributes(captcha);
        try {
            this.pageContext.getOut().write(captcha.getHtml());
        }
        catch (IOException iOException) {
            Logger.getLogger(CaptchaTag.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return 0;
    }

    public void setCodeLength(int n) {
        this.codeLength = n;
    }

    public void setUserInputID(String string) {
        this.userInputID = string;
    }

    public void setCodeStyle(String string) {
        this.codeStyle = CodeStyle.parseString((String)string);
    }

    public void setCodeTimeout(int n) {
        this.codeTimeout = n;
    }

    public void setDisallowedCodeSubstrings(String string) {
        this.disallowedCodeSubstrings = string;
    }

    public void setImageStyle(String string) {
        this.imageStyle = ImageStyle.parseCommaDelimitedString((String)string);
    }

    public void setImageFormat(String string) {
        this.imageFormat = ImageFormat.parseString((String)string);
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public void setImageHeight(int n) {
        this.imageHeight = n;
    }

    public void setCustomLightColor(String string) {
        this.customDarkColor = string;
    }

    public void setCustomDarkColor(String string) {
        this.customDarkColor = string;
    }

    public void setSoundEnabled(boolean bl) {
        this.soundEnabled = bl;
    }

    public void setSoundStyle(String string) {
        this.soundStyle = SoundStyle.parseCommaDelimitedString((String)string);
    }

    public void setSoundFormat(String string) {
        this.soundFormat = SoundFormat.parseString((String)string);
    }

    public void setSoundRegenerationMode(String string) {
        this.soundRegenerationMode = SoundRegenerationMode.parseString((String)string);
    }

    public void setSoundStartDelay(int n) {
        this.soundStartDelay = n;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public void setHelpLinkEnabled(boolean bl) {
        this.helpLinkEnabled = bl;
    }

    public void setHelpLinkMode(String string) {
        this.helpLinkMode = HelpLinkMode.parseString((String)string);
    }

    public void setTabIndex(int n) {
        this.tabIndex = n;
    }

    public void setImageTooltip(String string) {
        this.imageTooltip = string;
    }

    public void setSoundTooltip(String string) {
        this.soundTooltip = string;
    }

    public void setReloadTooltip(String string) {
        this.reloadTooltip = string;
    }

    public void setHelpLinkText(String string) {
        this.helpLinkText = string;
    }

    public void setHelpLinkUrl(String string) {
        this.helpLinkUrl = string;
    }

    public void setReloadEnabled(boolean bl) {
        this.reloadEnabled = bl;
    }

    public void setUseSmallIcons(boolean bl) {
        this.useSmallIcons = bl;
    }

    public void setUseHorizontalIcons(boolean bl) {
        this.useHorizontalIcons = bl;
    }

    public void setSoundIconUrl(String string) {
        this.soundIconUrl = string;
    }

    public void setReloadIconUrl(String string) {
        this.reloadIconUrl = string;
    }

    public void setIconsDivWidth(int n) {
        this.iconsDivWidth = n;
    }

    public void setAdditionalCssClasses(String string) {
        this.additionalCssClasses = string;
    }

    public void setAdditionalInlineCss(String string) {
        this.additionalInlineCss = string;
    }

    public void setAddCssInclude(boolean bl) {
        this.addCssInclude = bl;
    }

    public void setAddScriptInclude(boolean bl) {
        this.addScriptInclude = bl;
    }

    public void setAddInitScript(boolean bl) {
        this.addInitScript = bl;
    }

    public void setAutoFocusInput(boolean bl) {
        this.autoFocusInput = bl;
    }

    public void setAutoClearInput(boolean bl) {
        this.autoClearInput = bl;
    }

    public void setAutoUppercaseInput(boolean bl) {
        this.autoUppercaseInput = bl;
    }

    public void setAutoReloadExpiredCaptchas(boolean bl) {
        this.autoReloadExpiredCaptchas = bl;
    }

    public void setAutoReloadTimeout(int n) {
        this.autoReloadTimeout = n;
    }

    public void setRemoteScriptEnabled(boolean bl) {
        this.remoteScriptEnabled = bl;
    }

    private void setAttributes(Captcha captcha) {
        if (this.userInputID != null) {
            captcha.setUserInputID(this.userInputID);
        }
        if (this.codeLength != null) {
            captcha.setCodeLength(this.codeLength.intValue());
        }
        if (this.codeStyle != null) {
            captcha.setCodeStyle(this.codeStyle);
        }
        if (this.codeTimeout != null) {
            captcha.setCodeTimeout(this.codeTimeout.intValue());
        }
        if (this.disallowedCodeSubstrings != null) {
            captcha.setDisallowedCodeSubstringsCsv(this.disallowedCodeSubstrings);
        }
        if (this.imageStyle != null) {
            captcha.setImageStyle(this.imageStyle);
        }
        if (this.imageFormat != null) {
            captcha.setImageFormat(this.imageFormat);
        }
        if (this.imageWidth != null || this.imageHeight != null) {
            ImageSize imageSize = captcha.getImageSize();
            this.imageWidth = this.imageWidth != null ? this.imageWidth.intValue() : imageSize.getWidth();
            this.imageHeight = this.imageHeight != null ? this.imageHeight.intValue() : imageSize.getHeight();
            captcha.setImageSize(new ImageSize(this.imageWidth.intValue(), this.imageHeight.intValue()));
        }
        if (this.customLightColor != null) {
            captcha.setCustomLightColor(Color.decode(this.customLightColor));
        }
        if (this.customDarkColor != null) {
            captcha.setCustomDarkColor(Color.decode(this.customDarkColor));
        }
        if (this.soundEnabled != null) {
            captcha.setSoundEnabled(this.soundEnabled.booleanValue());
        }
        if (this.soundStyle != null) {
            captcha.setSoundStyle(this.soundStyle);
        }
        if (this.soundFormat != null) {
            captcha.setSoundFormat(this.soundFormat);
        }
        if (this.soundRegenerationMode != null) {
            captcha.setSoundRegenerationMode(this.soundRegenerationMode);
        }
        if (this.soundStartDelay != null) {
            captcha.setSoundStartDelay(this.soundStartDelay.intValue());
        }
        if (this.locale != null) {
            captcha.setLocale(this.locale);
        }
        if (this.helpLinkEnabled != null) {
            captcha.setHelpLinkEnabled(this.helpLinkEnabled.booleanValue());
        }
        if (this.helpLinkMode != null) {
            captcha.setHelpLinkMode(this.helpLinkMode);
        }
        if (this.tabIndex != null) {
            captcha.setTabIndex(this.tabIndex.intValue());
        }
        if (this.imageTooltip != null) {
            captcha.setImageTooltip(this.imageTooltip);
        }
        if (this.soundTooltip != null) {
            captcha.setSoundTooltip(this.soundTooltip);
        }
        if (this.reloadTooltip != null) {
            captcha.setReloadTooltip(this.reloadTooltip);
        }
        if (this.helpLinkText != null) {
            captcha.setHelpLinkText(this.helpLinkText);
        }
        if (this.helpLinkUrl != null) {
            captcha.setHelpLinkUrl(this.helpLinkUrl);
        }
        if (this.reloadEnabled != null) {
            captcha.setReloadEnabled(this.reloadEnabled.booleanValue());
        }
        if (this.useSmallIcons != null) {
            captcha.setUseSmallIcons(this.useSmallIcons.booleanValue());
        }
        if (this.useHorizontalIcons != null) {
            captcha.setUseHorizontalIcons(this.useHorizontalIcons.booleanValue());
        }
        if (this.soundIconUrl != null) {
            captcha.setSoundIconUrl(this.soundIconUrl);
        }
        if (this.reloadIconUrl != null) {
            captcha.setReloadIconUrl(this.reloadIconUrl);
        }
        if (this.iconsDivWidth != null) {
            captcha.setIconsDivWidth(this.iconsDivWidth.intValue());
        }
        if (this.additionalCssClasses != null) {
            captcha.setAdditionalCssClasses(this.additionalCssClasses);
        }
        if (this.additionalInlineCss != null) {
            captcha.setAdditionalInlineCss(this.additionalInlineCss);
        }
        if (this.addCssInclude != null) {
            captcha.setAddCssInclude(this.addCssInclude.booleanValue());
        }
        if (this.addScriptInclude != null) {
            captcha.setAddScriptInclude(this.addScriptInclude.booleanValue());
        }
        if (this.addInitScript != null) {
            captcha.setAddInitScript(this.addInitScript.booleanValue());
        }
        if (this.autoFocusInput != null) {
            captcha.setAutoFocusInput(this.autoFocusInput.booleanValue());
        }
        if (this.autoClearInput != null) {
            captcha.setAutoClearInput(this.autoClearInput.booleanValue());
        }
        if (this.autoUppercaseInput != null) {
            captcha.setAutoUppercaseInput(this.autoUppercaseInput.booleanValue());
        }
        if (this.autoReloadExpiredCaptchas != null) {
            captcha.setAutoReloadExpiredCaptchas(this.autoReloadExpiredCaptchas.booleanValue());
        }
        if (this.autoReloadTimeout != null) {
            captcha.setAutoReloadTimeout(this.autoReloadTimeout.intValue());
        }
        if (this.remoteScriptEnabled != null) {
            captcha.setRemoteScriptEnabled(this.remoteScriptEnabled.booleanValue());
        }
    }
}

