/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class HttpClient {
    private String url;
    private String method = "POST";
    private Properties params;
    private Properties headers;
    private String enc = "EUC_KR";
    private String content;
    private String contentType = "application/x-www-form-urlencoded";
    private File tmpDir = DEF_DIR;
    public static final String GET = "GET";
    public static final String POST = "POST";
    private static final String DEF_ENC = "EUC_KR";
    private static final String DEF_TYPE = "application/x-www-form-urlencoded";
    private static final File DEF_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final int size = 5120;
    private static final byte[] DUMMY_DATA = "dummy".getBytes();

    public HttpClient(String string, Properties properties) {
        this.url = string;
        this.params = properties;
    }

    public HttpClient(String string, String string2, String string3) {
        this.url = string;
        this.content = string2;
        this.contentType = string3;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void setEncoding(String string) {
        this.enc = string;
    }

    public void setHeaders(Properties properties) {
        this.headers = properties;
    }

    public void setTmpDir(File file) {
        this.tmpDir = file;
    }

    public Object run() throws IOException {
        int n;
        int n2;
        Object object;
        HttpURLConnection httpURLConnection = null;
        StringBuffer stringBuffer = null;
        if (this.params != null) {
            stringBuffer = new StringBuffer();
            object = this.params.keys();
            int n3 = 0;
            while (object.hasMoreElements()) {
                if (n3 != 0) {
                    stringBuffer.append('&');
                }
                String string = (String)object.nextElement();
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(this.params.getProperty(string)));
                ++n3;
            }
        }
        if (this.method.equals(GET) && stringBuffer != null) {
            this.url = this.url + "?" + stringBuffer.toString();
        }
        httpURLConnection = (HttpURLConnection)new URL(this.url).openConnection();
        if (this.headers != null) {
            object = this.headers.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                httpURLConnection.setRequestProperty(string, this.headers.getProperty(string));
            }
        }
        if (this.method.equals(POST)) {
            httpURLConnection.setRequestMethod(POST);
            httpURLConnection.setRequestProperty("Content-Type", this.contentType);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoOutput(true);
            object = httpURLConnection.getOutputStream();
            if (stringBuffer != null) {
                ((OutputStream)object).write(stringBuffer.toString().getBytes(this.enc));
            } else if (this.content != null) {
                ((OutputStream)object).write(this.content.getBytes(this.enc));
            } else {
                ((OutputStream)object).write(DUMMY_DATA);
            }
            ((OutputStream)object).close();
        }
        if ((n2 = httpURLConnection.getResponseCode()) != 200) {
            throw new IllegalStateException("HttpClient fail; response-code = " + n2);
        }
        int n4 = httpURLConnection.getContentLength();
        ByteArrayOutputStream byteArrayOutputStream = n4 != -1 ? new ByteArrayOutputStream(n4) : new ByteArrayOutputStream(5120);
        boolean bl = false;
        boolean bl2 = false;
        String string = httpURLConnection.getContentType();
        String string2 = httpURLConnection.getContentEncoding();
        if (string2 != null) {
            bl = string2.indexOf("gzip") != -1;
            bl2 = string2.indexOf("deflate") != -1;
        }
        byte[] byArray = new byte[512];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream(), 512);
        while ((n4 = ((InputStream)bufferedInputStream).read(byArray, 0, 512)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n4);
        }
        ((InputStream)bufferedInputStream).close();
        httpURLConnection.disconnect();
        bufferedInputStream = null;
        if (bl) {
            bufferedInputStream = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        } else if (bl2) {
            bufferedInputStream = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        }
        if (bufferedInputStream != null) {
            byteArrayOutputStream.reset();
            while ((n4 = ((InputStream)bufferedInputStream).read(byArray, 0, 512)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n4);
            }
            ((InputStream)bufferedInputStream).close();
        }
        if (string != null && string.startsWith("text")) {
            return new String(byteArrayOutputStream.toByteArray(), this.enc).trim();
        }
        String string3 = null;
        if (string != null && (n = string.indexOf("filename=")) != -1) {
            string3 = string.substring(n + 9);
            string3 = string3.trim();
        }
        File file = null;
        file = string3 != null ? new File(this.tmpDir, string3) : File.createTempFile("aireport", null, this.tmpDir);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byteArrayOutputStream.toByteArray());
        fileOutputStream.close();
        return file;
    }
}

