/*
 * Decompiled with CFR 0.152.
 */
package ChartDirector;

import ChartDirector.BlockParser;
import ChartDirector.DrawArea;
import ChartDirector.TTFText;
import ChartDirector.TextParser;
import ChartDirector.bs;
import ChartDirector.ef;
import ChartDirector.es;
import ChartDirector.ie;
import java.util.Vector;

class TTFBlocks
extends TTFText {
    private DrawArea drawarea;
    private int givenWidth;
    private int givenHeight;
    private int givenMaxWidth;
    private int givenMaxLines;
    private int halign;
    private int valign;
    private double angle;
    private int bgColor;
    private int edgeColor;
    private int topMargin;
    private int bottomMargin;
    private int leftMargin;
    private int rightMargin;
    private double lineSpacing;
    private int bidiType;
    private int width;
    private int height;
    private int ascender;
    private int descender;
    private int lineHSpan;
    private int lineVSpan;
    private int lineDistance;
    private Vector rawBlocks = new Vector();
    private Vector blocks;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    int getLineWidth() {
        return this.lineHSpan;
    }

    public int getLineHeight() {
        if (this.blocks.size() > 0) {
            return ((es)this.blocks.firstElement()).a.getLineHeight();
        }
        return this.height;
    }

    public int getLineDistance() {
        return this.lineDistance;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getDescender() {
        return this.descender;
    }

    public void draw(int n2, int n3, int n4, int n5) {
        this.drawOn(this.drawarea, n2, n3, n4, n5);
    }

    void drawOn(DrawArea drawArea, int n2, int n3, int n4, int n5) {
        n2 -= DrawArea.a(this.width, n5);
        n3 -= DrawArea.b(this.height, n5);
        if (0.0 != this.angle) {
            int n6 = 5;
            int n7 = 5;
            DrawArea drawArea2 = drawArea.e(this.lineHSpan + n6 + n7, this.lineVSpan);
            this.drawBlocks(drawArea2, n6, 0, n4, n5);
            double d2 = Math.toRadians(this.angle);
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            int n8 = (int)Math.round((double)n6 * Math.max(0.0, d4) + (double)n7 * Math.max(0.0, -d4));
            int n9 = (int)Math.round((double)n6 * Math.max(0.0, -d3) + (double)n7 * Math.max(0.0, d3));
            drawArea2.a(n2 - n8, n3 - n9, this.angle);
        } else {
            this.drawBlocks(drawArea, n2, n3, n4, n5);
        }
    }

    private void drawBlocks(DrawArea drawArea, int n2, int n3, int n4, int n5) {
        boolean bl2 = this.bidiType == 2;
        boolean bl3 = n5 != 7;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.bgColor != -16777216 || this.edgeColor != -16777216 && this.edgeColor != -1) {
            drawArea.rect(n2, n3, n2 + this.lineHSpan - 1, n3 + this.lineVSpan - 1, this.edgeColor == -1 ? this.bgColor : this.edgeColor, this.bgColor);
        }
        int n9 = 0;
        while (n9 < this.blocks.size()) {
            int n10;
            es es2 = (es)this.blocks.elementAt(n9);
            if ((bl3 || bl2) && es2.d != n6) {
                n6 = es2.d;
                n10 = 0;
                int n11 = n9;
                while (n11 < this.blocks.size()) {
                    es es3 = (es)this.blocks.elementAt(n11);
                    if (es3.d != es2.d) break;
                    n10 += es3.a.getWidth();
                    ++n11;
                }
                if (bl3) {
                    n7 = DrawArea.a(this.lineHSpan - n10 + 1, n5);
                }
                if (bl2) {
                    n8 = es2.b * 2 + n10;
                }
            }
            n10 = n2 + n7 + (bl2 ? n8 - es2.b - es2.a.getWidth() : es2.b);
            es2.a.drawOn(drawArea, n10 + this.leftMargin, n3 + es2.c + this.topMargin, n4, 7);
            ++n9;
        }
    }

    boolean startLayout(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        boolean bl2 = false;
        if (this.givenMaxWidth > 0 || ef.b(1, n3, 0x10000000)) {
            bl2 = this.wrapLayout(this.givenMaxWidth > 0 ? this.givenMaxWidth : n3, this.givenMaxLines > 0 ? this.givenMaxLines : n4);
        } else {
            this.noWrapLayout();
        }
        this.width = this.givenWidth <= 0 ? 0 : this.givenWidth;
        this.height = this.givenHeight <= 0 ? 0 : this.givenHeight;
        this.ascender = 0;
        this.descender = 0;
        this.lineDistance = 0;
        this.lineHSpan = 0;
        this.lineVSpan = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < this.blocks.size()) {
            int n12;
            n7 = ((es)this.blocks.elementAt((int)n11)).d;
            n6 = 0;
            n5 = n11;
            while (n5 < this.blocks.size()) {
                es es2 = (es)this.blocks.elementAt(n5);
                if (es2.d != n7) break;
                n6 += es2.a.getWidth();
                ++n5;
            }
            switch (this.halign) {
                case 6: {
                    n12 = -n6;
                    break;
                }
                case 3: {
                    n12 = -n6 / 2;
                    break;
                }
                default: {
                    n12 = 0;
                }
            }
            n8 = Math.min(n8, n12);
            n9 = Math.max(n9, n12 + n6);
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = n11;
            while (n16 < n5) {
                es es3 = (es)this.blocks.elementAt(n16);
                TTFText tTFText = es3.a;
                es3.b = n12;
                n12 += tTFText.getWidth();
                switch (this.valign) {
                    case 1: {
                        es3.c = 0;
                        break;
                    }
                    case 2: {
                        es3.c = -tTFText.getHeight();
                        break;
                    }
                    case 3: {
                        es3.c = -tTFText.getAscender() / 2;
                        break;
                    }
                    case 4: {
                        es3.c = -tTFText.getHeight() / 2;
                        break;
                    }
                    default: {
                        es3.c = -tTFText.getAscender();
                    }
                }
                n13 = Math.min(n13, es3.c);
                n14 = Math.max(n14, es3.c + tTFText.getHeight());
                n15 = Math.max(n15, es3.c + (int)Math.round((double)tTFText.getLineDistance() * this.lineSpacing));
                ++n16;
            }
            n16 = n11;
            while (n16 < n5) {
                ((es)this.blocks.elementAt((int)n16)).c += this.lineDistance - n13;
                ++n16;
            }
            n10 = this.lineDistance + n14 - n13;
            this.lineDistance += n15 - n13;
            this.descender = this.valign == 0 ? n14 : 0;
            n11 = n5;
        }
        n7 = 0;
        if (this.givenWidth <= 0) {
            n7 = -n8;
            this.width = n9 - n8;
        } else {
            switch (this.halign) {
                case 6: {
                    n7 = this.width;
                    break;
                }
                case 3: {
                    n7 = this.width / 2;
                }
            }
        }
        n6 = 0;
        if (this.givenHeight <= 0) {
            this.height = n10;
        } else {
            switch (this.valign) {
                case 2: {
                    n6 = this.height - n10;
                    break;
                }
                case 3: 
                case 4: {
                    n6 = (this.height - n10) / 2;
                }
            }
        }
        n5 = 0;
        while (n5 < this.blocks.size()) {
            es es4 = (es)this.blocks.get(n5);
            es4.b += n7;
            es4.c += n6;
            ++n5;
        }
        this.ascender = this.height - this.descender;
        this.width += this.leftMargin + this.rightMargin;
        this.height += this.topMargin + this.bottomMargin;
        this.lineHSpan = this.width;
        this.lineVSpan = this.height;
        if (0.0 != this.angle) {
            double d2 = Math.toRadians(this.angle);
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            this.width = (int)Math.ceil(Math.abs((double)this.lineVSpan * d4) + Math.abs(d3 * (double)this.lineHSpan) - 0.1);
            this.ascender = this.height = (int)Math.ceil(Math.abs((double)this.lineVSpan * d3) + Math.abs(d4 * (double)this.lineHSpan) - 0.1);
            this.lineDistance = this.height;
            this.descender = 0;
        }
        return bl2;
    }

    TTFText getNextLine() {
        return null;
    }

    TTFBlocks(DrawArea drawArea, String string, String string2, int n2, double d2, double d3, double d4, boolean bl2, int n3) {
        BlockParser blockParser = new BlockParser(string);
        blockParser.g = d4;
        if (n3 == 2 && d4 % 90.0 != 0.0) {
            n3 = 1;
        }
        if (n3 == 5 && d4 % 360.0 != 0.0) {
            n3 = 4;
        }
        TextParser textParser = new TextParser(string2, n2, d2, d3, n3);
        this.init(drawArea, blockParser, textParser, bl2, Math.abs(ef.c(d4, 90.0)) > 0.1);
    }

    private TTFBlocks(DrawArea drawArea, BlockParser blockParser, TextParser textParser, boolean bl2) {
        this.init(drawArea, blockParser, textParser, bl2, false);
    }

    private void init(DrawArea drawArea, BlockParser blockParser, TextParser textParser, boolean bl2, boolean bl3) {
        this.drawarea = drawArea;
        this.givenWidth = blockParser.c;
        this.givenHeight = blockParser.d;
        this.givenMaxWidth = blockParser.e;
        this.givenMaxLines = blockParser.f;
        this.angle = ef.c(blockParser.g, 360.0);
        this.valign = blockParser.a;
        this.halign = blockParser.b;
        this.bgColor = blockParser.h;
        this.edgeColor = blockParser.i;
        this.topMargin = blockParser.j;
        this.bottomMargin = blockParser.k;
        this.leftMargin = blockParser.l;
        this.rightMargin = blockParser.m;
        this.lineSpacing = blockParser.n;
        this.bidiType = blockParser.q;
        int n2 = 1;
        int n3 = this.rawBlocks.size();
        do {
            String string;
            if (!ef.c(string = blockParser.a())) {
                textParser.a(string);
                this.rawBlocks.add(new es(n2, new bs(drawArea, textParser, this.bidiType, bl2, bl3 && blockParser.o == '>')));
            }
            if (blockParser.o == '<') {
                this.rawBlocks.add(new es(n2, new TTFBlocks(drawArea, blockParser, (TextParser)textParser.clone(), bl2)));
                blockParser.o = (char)32;
                continue;
            }
            if (blockParser.o == 'i') {
                this.rawBlocks.add(new es(n2, new ie(drawArea, blockParser.p, blockParser.c, blockParser.d, blockParser.h, blockParser.i)));
                continue;
            }
            if (blockParser.o != '\n' && blockParser.o != '>') continue;
            if (n3 == this.rawBlocks.size()) {
                textParser.a(" ");
                this.rawBlocks.add(new es(n2, new bs(drawArea, textParser, this.bidiType, bl2, false)));
            }
            ++n2;
            n3 = this.rawBlocks.size();
        } while (blockParser.o != '>');
    }

    private boolean wrapLayout(int n2, int n3) {
        if (this.blocks == null) {
            this.blocks = new Vector();
        } else {
            this.blocks.clear();
        }
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.rawBlocks.size()) {
            es es2 = (es)this.rawBlocks.elementAt(n7);
            if (es2.d != n5) {
                if (++n4 > n3) break;
                n5 = es2.d;
                n6 = 0;
            }
            boolean bl2 = es2.a.startLayout(n6, n2, n3 - n4 + 1);
            int n8 = es2.a.getWidth();
            if (n6 != 0 && n6 + n8 > n2) {
                if (++n4 > n3) break;
                n6 = 0;
            }
            es2.d = n4;
            n6 += n8;
            this.blocks.addElement(es2);
            TTFText tTFText = es2.a;
            while (!bl2 && (tTFText = tTFText.getNextLine()) != null) {
                bl2 = tTFText.startLayout(0, n2, n3 - n4);
                es es3 = new es(++n4, tTFText);
                this.blocks.addElement(es3);
                n6 = es3.a.getWidth();
            }
            if (bl2) break;
            ++n7;
        }
        return n7 < this.rawBlocks.size();
    }

    private void noWrapLayout() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rawBlocks.size()) {
            TTFText tTFText = ((es)this.rawBlocks.elementAt((int)n3)).a;
            tTFText.startLayout(n2, Integer.MAX_VALUE, Integer.MAX_VALUE);
            n2 += tTFText.getWidth();
            ++n3;
        }
        this.blocks = this.rawBlocks;
    }

    public String toString() {
        String string = "[";
        int n2 = 0;
        while (n2 < this.blocks.size()) {
            string = String.valueOf(string) + this.blocks.elementAt(n2).toString();
            if (n2 != this.blocks.size()) {
                string = String.valueOf(string) + ", ";
            }
            ++n2;
        }
        return String.valueOf(string) + "]";
    }
}

